#include "mbed.h"

//Definition of digital pins - this is hardware dependant (you might chose to set it up diferently)
//In my case i had HDSP-5523 HER (High Efficiency Red) display where each led segment should consume 30mA
//On this display there are total 16 LED segment and if all of them would have been powered optimally there would not have been enough current as the USB port provides 0.5 A
//100mA is the consumption of the microcontroller itself so there is only 400mA for peripherals 400 - (16*30) = 400 - 480 = -80 mA
//So i would be 80 mA short + on top of that i have currently no resistors to cut the current from standard pin 40mA to just 30mA
//I decided to power just single digit of the display which as it seems is enough for the USB power.
//But if you have enough hardware and power for more digits or you have more power efficient display feel free to modify the code

DigitalOut pin1(p17);
DigitalOut pin2(p18);
DigitalOut pin3(p19);
DigitalOut dot(p20);
DigitalOut pin4(p21);
DigitalOut pin5(p22);
DigitalOut pin6(p23);
DigitalOut pin7(p24);


void display_number(short int show_number) { //Function to control which pins are to be lit with which number

    switch (show_number) {  //Switch statement decides which section of led display should light up -- this is dependent on hardware implementation
        case 0:             //If 0 is passed to the function and so on
            pin1 = 1;
            pin2 = 1;
            pin3 = 1;
            pin4 = 1;
            pin5 = 1;
            pin6 = 0;
            pin7 = 1;
            dot = 0;
            break;
        case 1:
            pin1 = 0;
            pin2 = 0;
            pin3 = 1;
            pin4 = 1;
            pin5 = 0;
            pin6 = 0;
            pin7 = 0;
            dot = 0;
            break;
        case 2:
            pin1 = 1;
            pin2 = 1;
            pin3 = 0;
            pin4 = 1;
            pin5 = 1;
            pin6 = 1;
            pin7 = 0;
            dot = 0;
            break;
        case 3:
            pin1 = 0;
            pin2 = 1;
            pin3 = 1;
            pin4 = 1;
            pin5 = 1;
            pin6 = 1;
            pin7 = 0;
            dot = 0;
            break;
        case 4:
            pin1 = 0;
            pin2 = 0;
            pin3 = 1;
            pin4 = 1;
            pin5 = 0;
            pin6 = 1;
            pin7 = 1;
            dot = 0;
            break;
        case 5:
            pin1 = 0;
            pin2 = 1;
            pin3 = 1;
            pin4 = 0;
            pin5 = 1;
            pin6 = 1;
            pin7 = 1;
            dot = 0;
            break;
        case 6:
            pin1 = 1;
            pin2 = 1;
            pin3 = 1;
            pin4 = 0;
            pin5 = 1;
            pin6 = 1;
            pin7 = 1;
            dot = 0;
            break;
        case 7:
            pin1 = 0;
            pin2 = 0;
            pin3 = 1;
            pin4 = 1;
            pin5 = 1;
            pin6 = 0;
            pin7 = 0;
            dot = 0;
            break;
        case 8:
            pin1 = 1;
            pin2 = 1;
            pin3 = 1;
            pin4 = 1;
            pin5 = 1;
            pin6 = 1;
            pin7 = 1;
            dot = 0;
            break;
        case 9:
            pin1 = 0;
            pin2 = 1;
            pin3 = 1;
            pin4 = 1;
            pin5 = 1;
            pin6 = 1;
            pin7 = 1;
            dot = 0;
            break;
    }
}

void null_display() {   //Function to light down the display (it seems that by default all the undefined pins have some small voltage by default)
    pin1 = 0;
    pin2 = 0;
    pin3 = 0;
    pin4 = 0;
    pin5 = 0;
    pin6 = 0;
    pin7 = 0;
    dot = 0;
}

int main() {
    short int number;           //Testing number
    null_display();             //Lets null the display first
    number = 0;                  //Set the initial number
    do {
        display_number(number);  //Display the number on the display
        wait(1.0);
        number++;                //Increment then umber
        if (number == 10) {      //If we ran out of digits reset the number to zero
            number = 0;
        }
    } while (number < 10);
}