#pragma once
#include "mbed.h"
#include "chamberData.h"
#include "genData.h"
#include "pulse.h"
#include "hardware.h"
#include "interface.h"
#include "voor.h"
#include "sense.h"
#include "motion.h"

int main(){
    hardware* io = new hardware();
    genData* generalData = new genData();
    chamberData* atrium = new chamberData('a');
    chamberData* ventricle = new chamberData('v');
    pulse* ventPulse = new pulse(ventricle,io);
    pulse* atrPulse = new pulse(atrium,io);
    
    Thread motionThread(osPriorityNormal);
    initialize_motion ();
    motion_set_chamber(0, ventricle);
    motionThread.start(motion_thread);
    
    queue myQueue
    Thread egramThread(osPriorityNormal);
    egramThread.start(storeData);
    
    interface a(io->getSerial() , ventPulse , generalData, atrium , ventricle,io); 
    
    a.startScreen();   
    
    
    delete ventricle; //code never reaches here, since we're stuck in the while loops of the pacing, user interface, etc.
    delete atrium;
    delete ventPulse;
    delete io;
    
return 0;
    }