#pragma once
#include "mbed.h"
#include "interface.h"
#include "hardware.h"
#include "chamberData.h"
#include "genData.h"
#include "pulse.h"
#include "voor.h"
#include "rtos.h"
#include "queue.h"
#include <stdlib.h>
#include <stdio.h>
#include <string>

//CONSTRUCTORS*****************************
interface::interface(): myQueue(1,N){
    }

interface::~interface(){};

interface::interface(Serial* inputPC): myQueue(1,N){
    pc = inputPC;
    }

interface::interface(Serial* inputPC , pulse* p ,genData* genData, chamberData* atrium , chamberData* ventricle, hardware* hardw): myQueue(1,N) {
    generalData = genData;
    pc = inputPC;
    interfacePulse = p;
    atrData = atrium;
    ventData = ventricle; 
    myHardware = hardw; 
    }
//********************************************


//USER INTERFACE SCREENS**************************   

void interface::startScreen(){
    
    pc->printf("\n ____   _    ____ _____ __  __    _    _  _______ ____  ");
    pc->printf("\n|  _ \\ / \\  / ___| ____|  \\/  |  / \\  | |/ / ____|  _ \\");
    pc->printf("\n| |_) / _ \\| |   |  _| | |\\/| | / _ \\ | ' /|  _| | |_) |");
    pc->printf("\n|  __/ ___ \\ |___| |___| |  | |/ ___ \\| . \\| |___|  _ <");
    pc->printf("\n|_| /_/   \\_\\____|_____|_|  |_/_/   \\_\\_|\\_\\_____|_| \\_\\");
    
    
    pc->printf("\nWelcome to the PACEMAKER DCM.\n");
    pc->printf("Options:\n");
    pc->printf("1. Start VOOR Pulse\n"); // temporary test to get VOOR working
    pc->printf("2. View/Change data\n");
    pc->printf("Please enter a command:");
    char command = getChar();
    switch (command) {
        case '1':{
            
            voor v(interfacePulse, ventData); //creates new instance of voor
            v.startPace(); //starts pacing voor the same way as it used to pace in the user interface
            //interfacePulse->startPulse(); //problems with this method: you create the pc output twice, once in UI and once in pulse.
            startScreen();                             //realistically we'll never need to call the serial output in pulse, it should all be done in UI
            break;
            }
        case '2':
            interface::dataScreen();
            break;
        default:
            pc->printf("\nThat is not an option.\n");
            interface::startScreen();
            break;
    }   
}

void interface::dataScreen(){
    (*pc).printf("\nDCM Data sets:\n");
    (*pc).printf("1. Atrium Data\n2. Ventricle Data\n3. General Data\n4. Egram Data\n5. Back to start page\n");
    (*pc).printf("Choose a data set:");
    char command = getChar();
    switch (command) {
        case '1':
            interface::chamberDataScreen(atrData);
        case '2':
            interface::chamberDataScreen(ventData);
        case '3':
            interface::genDataScreen();
        case '4':
            interface::getEgram();
            break;
        case '5':
            interface::startScreen();  
        default:
            pc->printf("\nThat is not an option.\n");
            interface::dataScreen();
    }  
}

void interface::chamberDataScreen(chamberData* chamber){
    if (chamber == atrData)
    pc->printf("\nAtrium Data");
    
    if (chamber == ventData)   
    pc->printf("\nVentricle Data");
    
    pc->printf("\n1. Pace Amplitude: %f", chamber->getPaceAmp()*7);
    pc->printf("\n2. Pace Width: %f", chamber->getPaceWidth());
    pc->printf("\n3. Refractory Period: %f", chamber->getRP());
    pc->printf("\n4. Sensitivity: %f", chamber->getSensitivity());
    pc->printf("\nChoose variable to be changed or 5 To return to Data Sets");
    
    char command = getChar();
    switch (command){
        case '1':
            pc->printf("\nChoose New Value for the Pace Amplitude:");
            char* value = getInput();
            int valInRange = chamber->chngPaceAmp(atof(value));
            if(valInRange == 1){
                pc->printf("\t%f",chamber->getPaceAmp()*7);
            }else{
                pc->printf("\nThat value is not within range.");   
            }
            interface::chamberDataScreen(chamber);
            break;
        case '2':
            pc->printf("\nChoose New Value for the Pace Width:");
            value = getInput();
            valInRange = chamber->chngPaceWidth(atof(value));
            if(valInRange == 1){
                pc->printf("\t%f",chamber->getPaceWidth());
            }else{
                pc->printf("\nThat value is not within range.");   
            }
            interface::chamberDataScreen(chamber);
            break;
        case '3':
            pc->printf("\nChoose New Value for the Refractory Period:");
            value = getInput();
            valInRange = chamber->chngRP(atof(value));
            if(valInRange == 1){
                pc->printf("\t%f",chamber->getRP());
            }else{
                pc->printf("\nThat value is not within range.");   
            }
            interface::chamberDataScreen(chamber);
            break;
        case '4':
            pc->printf("\nChoose New Value for the Sensitivity:");
            value = getInput();
            valInRange = chamber->chngSensitivity(atof(value));
            if(valInRange == 1){
                pc->printf("\t%f",chamber->getSensitivity());
            }else{
                pc->printf("\nThat value is not within range.");   
            }
            interface::chamberDataScreen(chamber);
            break;
        case '5':
            interface::dataScreen();
            break;
        default:
            pc->printf("\nThat is not an option.");
            interface::chamberDataScreen(chamber);
            break;
    }  
}

void interface::genDataScreen(){ //moved option 3 from dataScreen() into its own method
    pc->printf("\nGeneral Data");
    pc->printf("\n1. Hysteresis: %s", generalData->getHyst() ? "true" : "false");
    pc->printf("\n2. Hysteresis Rate Limit: %f", generalData->getHystRL());
    pc->printf("\n3. Lower Rate Limit: %f", generalData->getLRL());
    pc->printf("\n4. Upper Rate Limit: %f", generalData->getURL());
    pc->printf("\n5. Atrial-Ventricular Delay: %f", generalData->getAVdelay());
    pc->printf("\n6. Atrial-Ventricular Delay Offset: %f" , generalData->getAVdelayOffset());
    pc->printf("\n7. Rate Smoothing: %f", generalData->getRSmooth());
    pc->printf("\nChoose variable to be changed or 8 To return to Data Sets");      
    char command = getChar();
    switch (command) {
        case '1':
            pc->printf("\nSet Hysteresis (t for true, f for false):");
            char* value = getInput();
            if(*value == 't'){
                generalData->chngHyst(true);
            }else if(*value == 'f'){
                generalData->chngHyst(false);
            }else{
                pc->printf("You may only enter 't' or 'f'.");   
            }
            pc->printf("%s", generalData->getHyst() ? "true" : "false");
            interface::genDataScreen();
            break;
        case '2':
            pc->printf("\nChoose New Value for Hysteresis Rate Limit:");
            value = getInput();
            int valInRange = generalData->chngHystRL(atof(value));
            if(valInRange == 1){
                pc->printf("\t%f",generalData->getHystRL());
            }else{
                pc->printf("\nThat value is not within range.");   
            }
            interface::genDataScreen();
            break;
        case '3':
            pc->printf("\nChoose New Value for the Lower Rate Limit:");
            value = getInput();
            valInRange = generalData->chngLRL(atof(value));
            if(valInRange == 1){
                pc->printf("\t%f",generalData->getLRL());
            }else{
                pc->printf("\nThat value is not within range.");   
            }
            interface::genDataScreen();
            break;
        case '4':
            pc->printf("\nChoose New Value for the Upper Rate Limit:");
            value = getInput();
            valInRange = generalData->chngURL(atof(value));
            if(valInRange == 1){
                pc->printf("\t%f",generalData->getURL());
            }else{
                pc->printf("\nThat value is not within range.");   
            }
            interface::genDataScreen();
            break;
        case '5':
            pc->printf("\nChoose New Value for the Atrial-Ventricular Delay:");
            value = getInput();
            valInRange = generalData->chngAVdelay(atof(value));
            if(valInRange == 1){
                pc->printf("\t%f",generalData->getAVdelay());
            }else{
                pc->printf("\nThat value is not within range.");   
            }
            interface::genDataScreen();
            break; 
        case '6':
            pc->printf("\nChoose New Value for the Atrial-Ventricular Delay Offset:");
            value = getInput();
            valInRange = generalData->chngAVdelayOffset(atof(value));
            if(valInRange == 1){
                pc->printf("\t%f",generalData->getAVdelayOffset());
            }else{
                pc->printf("\nThat value is not within range.");  
            }
            interface::genDataScreen();
            break;
        case '7':
            pc->printf("\nChoose New Value for the Rate Smoothing:");
            value = getInput();
            valInRange = generalData->chngRSmooth(atof(value));
            if(valInRange == 1){
                pc->printf("\t%f",generalData->getRSmooth());
            }else{
                pc->printf("\nThat value is not within range.");   
            }
            interface::genDataScreen();
            break;
        case '8':
            interface::dataScreen();
            break;
        default:
            pc->printf("\nThat is not an option.\n");
            interface::genDataScreen();
            break;
    }  
}

//void interface::getData(chamberData* chamber){
//    char command = getChar();
//    switch (command){
//        case '1':
//            pc->printf("\nChoose New Value:");
//            char* value = getInput();
//            chamber->chngPaceAmp(atof(value));
//            pc->printf("\t%f",chamber->getPaceAmp()*7);
//            interface::dataScreen();
//            break;
//        case '2':
//            pc->printf("\nChoose New Value:");
//            value = getInput();
//            chamber->chngPaceWidth(atof(value));
//            pc->printf("\t%f",chamber->getPaceWidth());
//            interface::dataScreen();
//            break;
//        case '3':
//            pc->printf("\nChoose New Value:");
//            value = getInput();
//            chamber->chngRP(atof(value));
//            pc->printf("\t%f",chamber->getRP());
//            interface::dataScreen();
//            break;
//        case '4':
//            pc->printf("\nChoose New Value:");
//            value = getInput();
//            chamber->chngSensitivity(atof(value));
//            pc->printf("\t%f",chamber->getSensitivity());
//            interface::dataScreen();
//            break;
//        case '5':
//            interface::dataScreen();
//            break;
//        default:
//            pc->printf("\nThat is not an option.");
//            interface::getData(chamber);
//    }  
// }
 
void interface::getEgram(){
    //myDataStruct = new dataStruct(myHardware);
    isEgram = true;
    pc->printf("\nPress 1 to stop streaming egram data");
    while(isEgram){
        if(pc->readable()){
            char command = pc->getc();
            if(command == '1'){
                isEgram = false;
                }
            }
        
        Thread::wait(40);
        myQueue = getData();
        //I know below doesn't look neat, but it just will print values to the screen for now. One day we may do a graph. 
        myQueue.Get( &nTemp );
        pc->printf( "Item 1 = %d\r", nTemp );
        myQueue.Get( &nTemp );
        pc->printf( "Item 2 = %d\r", nTemp );
        myQueue.Get( &nTemp );
        pc->printf( "Item 3 = %d\r", nTemp );
        myQueue.Get( &nTemp );
        pc->printf( "Item 4 = %d\r", nTemp );
        myQueue.Get( &nTemp );
        pc->printf( "Item 5 = %d\r", nTemp );
        myQueue.Get( &nTemp );
        pc->printf( "Item 6 = %d\r", nTemp );
        myQueue.Get( &nTemp );
        pc->printf( "Item 7 = %d\r", nTemp );
        myQueue.Get( &nTemp );
        pc->printf( "Item 8 = %d\r", nTemp );
        myQueue.Get( &nTemp );
        pc->printf( "Item 9 = %d\r", nTemp );
        myQueue.Get( &nTemp );
        pc->printf( "Item 10 = %d\r", nTemp );
    }
   // delete myDataStruct;
}

 
char* interface::getInput(){
    char buffer[5];
    fgets (buffer,5,stdin);
    return buffer;
}

char interface::getChar(){
    while(true){
        if(pc->readable()){
            char command = pc->getc();
            return command;   
            }   
        }   
}
//****************************

//void interface::getAPulse(){ //TODO get this to work, the wait command has issues, see pulse.cpp . wait takes in seconds as argument
//    pulse myPulse(*atr);
//    myPulse.setWidth(1);
//    myPulse.startPulse();
//    }
    
//void interface::LEDon(AnalogOut* out){
//    (*out) = 0;
////    (*pc).printf(led);
//}
//    
//void interface::LEDoff(AnalogOut* out){
//    (*out) = 1;
//}