#pragma once
#include "mbed.h"
#include "hardware.h"
#include "chamberData.h"
#include "genData.h"
#include "pulse.h"
#include "dataStruct.h"
#include "queue.h"

class interface{

public:
    interface();
    ~interface();
    interface(Serial*);
    interface(Serial* , pulse* , genData*, chamberData* , chamberData*, hardware*);
    void startScreen();

//    void setAtrium(AnalogOut&);
//    void setVentricle(AnalogOut&);
//    void LEDon(AnalogOut*);
//    void LEDoff(AnalogOut*);

      
private:
    void dataScreen();
    void genDataScreen();
    void chamberDataScreen(chamberData*);
    void getData(chamberData*);
    void chngVentData();
    char* getInput();
    char getChar();
    void changeData(int , double); // UI tells the user to you 1 for atrium, 2 for ventricle, etc.
    void getData(int);
    void getEgram();
    bool isEgram;
    Serial* pc;
    pulse* interfacePulse;
    pulse* atrPulse;
    genData* generalData;
    chamberData* atrData;
    chamberData* ventData;
    //dataStruct* myDataStruct;
    extern getData();
    hardware* myHardware;
    queue myQueue;
    unsigned char nTemp;
    static const int N = 13;
};