/*
 * tlc5940 - Interface to operate TI's IC TLC5940
 * Copyright (C) 2010 German Bassi.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "tlc5940.h"
#include "mbed.h"

tlc5940::tlc5940 (int num_ics, int DC_data[]) :
        num_ic(num_ics), VPROG(p21), SIN(p22), SCLK(p23), XLAT(p24),
        BLANK(p25), DCPROG(p27), GSCLK(p26), SOUT(p28), XERR(p29) {
    first_cycle_flag = false;

    // Pins in startup state
    GSCLK = 0;
    SCLK = 0;
    VPROG = 1;
    XLAT = 0;
    BLANK = 1;
    DCPROG = 0;
    wait(0.01);

    // DC input cycle starts
    DCPROG = 1;
    VPROG = 1;

    for (int counter=0; counter < (num_ic*96); counter++) {
        SIN = DC_data[counter];
        SCLK = 1;
        wait_us(5);
        SCLK = 0;
        wait_us(5);
    }
    XLAT = 1;
    wait_us(5);
    XLAT = 0;
    wait_us(5);
    DCPROG = 0;
    // DC input cycle ends
}

void tlc5940::send_data (int data[]) {
    // Grayscale data input + Grayscale PWM
    data_counter = 0;
    GSCLK_counter = 0;

    if (VPROG == 1) {
        VPROG = 0;
        first_cycle_flag = true;
    }

    // Send the new data
    BLANK = 0;
    for (GSCLK_counter = 0; GSCLK_counter <= 4095; GSCLK_counter++) {
        if (data_counter < num_ic*192) {
            // Every new led consists of 12 bits
            aux_ind = data_counter % 12;
            if ( aux_ind == 0 ) aux_value = data[data_counter/12];
            // Send the last bit
            SIN = (aux_value >> aux_ind) & 0x01;

            SCLK = 1;
            GSCLK = 1;
            SCLK = 0;
            GSCLK = 0;

            data_counter++;
        } else {
            GSCLK = 1;
            GSCLK = 0;
        }
    }
    BLANK = 1;

    XLAT = 1;
    XLAT = 0;

    if (first_cycle_flag) {
        SCLK = 1;
        SCLK = 0;
        first_cycle_flag = false;
    }
}
