#ifndef MBED_LED_CUBE_H
#define MBED_LED_CUBE_H

#include "mbed.h"

namespace mbed {

class led_cube {
private:
    // indices de leds ordenados
    int indices[25];
    // indices para hacer espiral
    int col_espiral[25];
    int fil_espiral[25];
    // leds de la vibora de largo 5
    int vibora_leds[5][3];
    bool vibora_viva;
    // indice de demo
    int ind_demo;

public:
    // datos de DC
    int DC_data [2*96];
    // datos de leds
    int GS_data[5][32];

    led_cube (void);
    inline void apagar_leds (void);
    inline void prender_leds (void);
    void prender_un_led (int piso, int fila, int columna);
    void apagar_un_led (int piso, int fila, int columna);
    void next_led (void);
    void prender_alto (int fila, int col);
    void apagar_alto (int fila, int col);
    void next_alto (void);
    void next_alto_espiral (void);
    void prender_largo (int piso, int fila);
    void apagar_largo (int piso, int fila);
    void next_largo_espiral (void);
    void prender_ancho (int piso, int col);
    void apagar_ancho (int piso, int col);
    void next_ancho_espiral (void);
    void uba_gode (void);
    void aleatorio (void);
    void un_led_aleatorio (void);
    void un_led_caminando (void);
    void vibora_inicia (void);
    void vibora_camina (void);
    void prender_piso (int piso);
    void sube_ola_vert (int piso);
    void baja_ola_vert (int piso);
    void mueve_ola (void);
    void demo_inc (void);
    void demo_show (void);
};
}

#endif