/* Codigo de ejemplo para probar los PWMs, Tickers, Timer...
* La idea es prender los leds en forma "random" y que los leds cambien su intensidad
* cambiando el duty del PWM que se les manda, simulando "estrellas".
* El comportamiento random lo sacamos del valor de un timer al momento de la lectura. Probamos usar el ADC,
* no logramos que varie.
* El codigo tiene muchos valores "magicos" que salen de probar cosas para que el efecto "quede lindo".
* Copiright Joaquin de Andres, Lucas Chiesa under the GNU GPL Version 2 or later.
*/

#include "mbed.h"

// Cramos un tipo para guardar el estado actual de cada led.
// NOTA: APAGADO ahora no apaga los leds, sino que les baja el brillo mucho mas rapido porque sino quedaba feo.
typedef enum {SUBIENDO, BAJANDO, APAGADO} led_status;

// Creamos los PWMs que vamos a usar para alimentar los LEDs.
PwmOut led1(LED1);
PwmOut led2(LED2);
PwmOut led3(LED3);
PwmOut led4(LED4);

// Creamos un timer.
Timer t;

// Creamos 4 tickers, cada uno puede tener 1 solo callback.
Ticker tick1;
Ticker tick2;
Ticker tick3;
Ticker tick4;

led_status led1_status = SUBIENDO;
led_status led2_status = BAJANDO;
led_status led3_status = SUBIENDO;
led_status led4_status = BAJANDO;

// Handlers para cambiar el PWM de cada led. Como se les pueden pasar argumentos, creamos una para cada uno.
// Supongo que se podria ver alguna forma de reutilizar el codigo.
void led1_tick() {
    switch (led1_status) {
        case SUBIENDO:
            led1 = (led1 < 1)? (led1 + 0.001) : led1;
            break;
        case BAJANDO:
            led1 = (led1 > 0.003)? (led1 - 0.003) : led1;
            break;
        case APAGADO:
            led1 = (led1 >= 0.01)? (led1 - 0.01) : led1;
    }
}

void led2_tick() {
    switch (led2_status) {
        case SUBIENDO:
            led2 = (led2 < 1)? (led2 + 0.002) : led2;
            break;
        case BAJANDO:
            led2 = (led2 > 0.001)? (led2 - 0.001) : led2;
            break;
        case APAGADO:
            led2 = (led2 >= 0.01)? (led2 - 0.01) : led2;
    }
}

void led3_tick() {
    switch (led3_status) {
        case SUBIENDO:
            led3 = (led3 < 1)? (led3 + 0.003) : led3;
            break;
        case BAJANDO:
            led3 = (led3 > 0.004)? (led3 - 0.004) : led3;
            break;
        case APAGADO:
            led3 = (led3 >= 0.01)? (led3 - 0.01) : led3;
    }
}

void led4_tick() {
    switch (led4_status) {
        case SUBIENDO:
            led4 = (led4 < 1)? (led4 + 0.001) : led4;
            break;
        case BAJANDO:
            led4 = (led4 > 0.001)? (led4 - 0.001) : led4;
            break;
        case APAGADO:
            led4 = (led4 >= 0.01)? (led4 - 0.01) : led4;
    }
}

// Esta funcion devuelve un estado segun la variable aux que se le pasa.
led_status set_status (int aux) {
    if (aux == 0 ) {
        return SUBIENDO;
    } else if (aux == 1) {
        return BAJANDO;
    } else {
        return APAGADO;
    }
}

int main() {
// Condiciones iniciales distintas para cada led.
    led1 = 0;
    led2 = 0.5;
    led3 = 0.6;
    led4 = 1;

    int aux;

// Hacemos que cada led cambie a distinta frecuencia, y sin que sean multiplos.
    tick1.attach(&led1_tick, 0.002);
    tick2.attach(&led2_tick, 0.005);
    tick3.attach(&led3_tick, 0.003);
    tick4.attach(&led4_tick, 0.001);

// No hay que olvidarse de iniciar el timer para que esto ande!!
    t.start();
    wait(0.2);

    while (1) {
// Para cada led, leemos el valor del timer (en distintas unidades),
// le hacemos modulo 3, y eso lo usamos como valor "random" para cambiar el estado de los leds.

        aux = t.read_us();
        aux = aux % 3;
        led1_status = set_status(aux);
        wait(0.001);

        aux = t.read_us();
        aux = aux % 3;
        led2_status = set_status(aux);
        wait(0.002);

        aux = t.read_us();
        aux = aux % 3;
        led3_status = set_status(aux);
        wait(0.005);

        aux = t.read_us()-0.5;
        aux = aux % 3;
        led4_status = set_status(aux);

        wait(1);
    }
}
