#include "mbed.h"
#include "BLE_Driver.h"

DigitalOut LIVE_LED(LED1, 1);
DigitalOut CONECT_LED(LED2, 1);
DigitalOut TEST_LED(LED3, 1);
DigitalIn TEST_BUTTON(p17,PullUp);

void callbackBLE(int event) {
    switch (event){
        case 1:     CONECT_LED = 0; break;
        case 2:     CONECT_LED = 1; break;
        default:    break;
        }
    }

void periodicCallback(void){
    LIVE_LED =! LIVE_LED;
    uint8_t a;
    a= getBLE();
    if (a=='G')
        TEST_LED = !TEST_LED;
    }

int main(void){
    Ticker Flasher;
    Flasher.attach(periodicCallback, 1);
    iniBLE("Sigfried");
    while(1){
        if (TEST_BUTTON == 0)
            putBLE("Hola\n\r");
        }
    }
    
