/*
    Software to read out rotary encoder through serial terminal readout
    Rotary encoder: YUMO E6B2-CWZ3E
    Connections: Brown to 5V supply on board
                 Blue to Ground (0V) on board
                 Data lines White and black to A0 and A1 (not sure which to which)
                 Orange not connected (open)
                 
    Code based on "Nucleo_Hello_Encoder" on mbed by David Lowe:
    https://os.mbed.com/users/gregeric/code/Nucleo_Hello_Encoder/
    
    Odacon B.V. - Ferry Musters - 2019
*/

#include "mbed.h"
#include "Encoder.h"

//STM mbed bug: these macros are MISSING from stm32f3xx_hal_tim.h
#ifdef TARGET_STM32F3
#define __HAL_TIM_GET_COUNTER(__HANDLE__) ((__HANDLE__)->Instance->CNT)
#define __HAL_TIM_IS_TIM_COUNTING_DOWN(__HANDLE__)            (((__HANDLE__)->Instance->CR1 &(TIM_CR1_DIR)) == (TIM_CR1_DIR))
#endif

Serial pc(USBTX, USBRX); // tx, rx

TIM_Encoder_InitTypeDef encoder1, encoder2, encoder3, encoder4;
TIM_HandleTypeDef  timer1,  timer2,  timer3,  timer4;

int main()
{
    //counting on both A&B inputs, 4 ticks per cycle, full 32-bit count
    EncoderInit(&encoder2, &timer2, TIM2, 0xffffffff, TIM_ENCODERMODE_TI12);

    uint32_t lastvalue = __HAL_TIM_GET_COUNTER(&timer2);
    int overflowcount = 0;
    while(1) {
        uint32_t currentvalue =__HAL_TIM_GET_COUNTER(&timer2);
        int8_t dir = __HAL_TIM_IS_TIM_COUNTING_DOWN(&timer2);

        float pulsesperrevolution = 1024*4;
        //keep track of a possible overflow
        if((float)lastvalue - (float)currentvalue > 30000) { //with this huge value we must have an overflow
            //pc.printf("Overflow happened, curval: %d lastval: %d, overflowcount: %d\r\n", currentvalue, lastvalue, overflowcount);
            overflowcount++;
        }
        if((float)currentvalue - (float)lastvalue > 30000) { //underflow
            //pc.printf("Underflow happened, curval: %d lastval: %d, overflowcount: %d\r\n", currentvalue, lastvalue, overflowcount);
            overflowcount--;
        }
        float pulsevalue = (float) currentvalue + (float) overflowcount * 0x10000;
        float fullrotations = (currentvalue/pulsesperrevolution) + overflowcount * 0x10000/pulsesperrevolution;

        char inchar = ' ';
        scanf("%c",&inchar);
        if(inchar == 'i' || inchar == 'I') {
            pc.printf("Rotary\r\n");
        } else if(inchar == 'm' || inchar == 'M') {
            pc.printf("%f\r\n", fullrotations);
            //pc.printf("%d, %f%s \r\n", overflowcount, fullrotations, dir==0 ? "+":"-");
            //pc.printf("%d: %f%s \r\n", i++, (currentvalue/pulsesperrevolution), dir2==0 ? "+":"-");
        } else if(inchar == 'p' || inchar == 'P') {
            pc.printf("%f\r\n", pulsevalue);
        }
        lastvalue = currentvalue;
    }
}

