#include "mbed.h"
#include "QEI.h"
#include "math.h"
#include "HIDScope.h"



// Motor 1 & 2
DigitalOut      Direction(D4); //1 = CCW - 0 = CW, moet nog omgezet worden naar up en down
PwmOut          PowerMotor(D5); //van 0 tot 1
QEI             Encoder(D10,D11,NC,32,QEI::X2_ENCODING); //Encoder
DigitalOut      Direction2(D7);
PwmOut          PowerMotor2(D6);
QEI             Encoder2(D12,D13,NC,32,QEI::X2_ENCODING);
PwmOut          PowerServo(D3);

// Buttons & EMG (PotMeter)
DigitalIn       Button(PTC6);
DigitalIn       Button2(PTA4);
AnalogIn        EMG(A0);
AnalogIn        EMG2(A1);

// Tickers & timers

Ticker          biquadTicker;
Ticker          MotorWrite;
Ticker          Sender;
Timer           timer;
Timer           TijdEMGCal;

// Debugging
Serial          pc(USBTX, USBRX);
HIDScope        scope(6);



// Waardes
const double    twopi = 6.2831853071795;
const double    Fs=100;
int             Fired = 0;

// EMG
double          emg_value;
double          emg_value2;
const double    T1 = 0.33333; // Treshold 1
const double    T2 = 0.66666; // Treshold 2

// Motor 1 (Translatie)
double          n1 = 3.861464193; // Aantal rondjes dat ons apparaat maximaal mag draaien (omhoog)
int             Pulses;
double          Rotatie = 0; //aantal graden dat de motor is gedraaid
double          Goal; //initele waarde goal waar de motor naar toe moet, dit wordt gedaan
double          Error = 0;
double          Errord = 0;
double          Errori = 0;
double          Errorp = 0;
const double    Kp = 0.2; //Moet berekend worden aan de hand van Control concept slides
const double    Kd = 10;
const double    Ki = 0.2;
double          v = 0; //snelheid van de motor (0-0.1)?
double          upperlimit; //max aantal rotaties omhoog
const double    downlimit = 0.4;
const double    margin = 0.4;
bool            OutRange = false;

// Motor 2 (Rotatie)
double          n2 = 0.3125; // Aantal rondjes dat dat ons apparaat maximaal mag draaien (rotatie)
int             Pulses2;
double          Rotatie2 = 0;
double          Goal2;
double          Error2 = 0;
double          Errord2 = 0;
double          Errori2 = 0;
double          Errorp2 = 0;
const double    Kp2 = 0.2;
const double    Kd2 = 10;
const double    Ki2 = 0.2;
double          v2 = 0;
double          turnlimit = 0.4; // max aantal rotaties voor roteren hele robot
// Margin 2 is in ons geval 0
bool            OutRange2 = false;

// Activatie tussen het schietgedeelte en terugkeergedeelte
bool            Excecute = false;
bool            Home = false;

// Filter
double Fs2 = 500; // in Hz
const double TijdCal = 5;
double Max = 0;
double Max2 = 0;
bool Cali = false;

double u1;
double y1;
double y2;
double y3;
double y4;
double y5;
double y6;
double y7;
double y8;

double u10;
double y10;
double y12;
double y13;
double y14;
double y15;
double y16;
double y17;
double y18;

double f1_v1=0,f1_v2=0;
double f2_v1=0,f2_v2=0;
double f3_v1=0,f3_v2=0;
double f4_v1=0,f4_v2=0;
double f5_v1=0,f5_v2=0;
double f6_v1=0,f6_v2=0;
double f7_v1=0,f7_v2=0;

double f1_v3=0,f1_v4=0;
double f2_v3=0,f2_v4=0;
double f3_v3=0,f3_v4=0;
double f4_v3=0,f4_v4=0;
double f5_v3=0,f5_v4=0;
double f6_v3=0,f6_v4=0;
double f7_v3=0,f7_v4=0;

// Notch
const double gainNotch3=0.969922;
const double f3_a1=-1.56143694016, f3_a2=0.93984421899, f3_b0=1.00000000000, f3_b1=-1.60985807508, f3_b2=1.00000000000;
const double gainNotch4=0.975183;
const double f4_a1=-1.55188488157,f4_a2=0.96839115647,f4_b0=1.000000000,f4_b1=-1.60985807508,f4_b2=1.00000000;
const double gainNotch5=0.993678;
const double f5_a1=-1.61645491476,f5_a2=0.97057916088,f5_b0=1.000000000,f5_b1=-1.60985807508,f5_b2=1.00000000;

// High pass
const double gainHP1=0.939472;
const double f1_a1=-0.87894202296,f1_a2=0.00000000,f1_b0=1.0000000,f1_b1=-1.00000000,f1_b2=0.000000000;
const double gainHP2=0.935820;
const double f2_a1=-1.86387364983,f2_a2=0.87941229211,f2_b0=1.0000000000,f2_b1=-2.0000000,f2_b2=1.0000000;

// Low pass
const double gainLP6=0.000048;
const double f6_a1=-1.97326192076 , f6_a2=0.97345330126 , f6_b0=1.0000000 , f6_b1=2.0000000 , f6_b2=1.0000000;
const double gainLP7=0.000048;
const double f7_a1=-1.98030504048 , f7_a2=0.98049710408 , f7_b0=1.0000000 , f7_b1=2.0000000 , f7_b2=1.0000000;



// Voids voor berekeningen in het hoofdprogramma

double biquad(double u, double &v1, double &v2, const double a1, const double a2, const double b0, const double b1, const double b2)
{
    double v = u-a1*v1-a2*v2;
    double y=b0*v+b1*v1+b2*v2;
    v2=v1;
    v1=v;
    return y;
}

void myController()
{
    // EMG 1
    u1 = EMG.read();
    // Notch
    double y1 = biquad(u1,f3_v1,f3_v2,f3_a1,f3_a2,f3_b0*gainNotch3,f3_b1*gainNotch3,f3_b2*gainNotch3);
    double y2 = biquad(y1,f4_v1,f4_v2,f4_a1,f4_a2,f4_b0*gainNotch4,f4_b1*gainNotch4,f4_b2*gainNotch4);
    double y3 = biquad(y2,f5_v1,f5_v2,f5_a1,f5_a2,f5_b0*gainNotch5,f5_b1*gainNotch5,f5_b2*gainNotch5);

    // HP
    double y4 = biquad(y3,f1_v1,f1_v2,f1_a1,f1_a2,f1_b0*gainHP1,f1_b1*gainHP1,f1_b2*gainHP1);
    double y5 = biquad(y4,f2_v1,f2_v2,f2_a1,f2_a2,f2_b0*gainHP2,f2_b1*gainHP2,f2_b2*gainHP2);

    // LP
    y6 = fabs(y5);
    double y7 = biquad(y6,f6_v1,f6_v2,f6_a1,f6_a2,gainLP6*f6_b0,gainLP6*f6_b1,gainLP6*f6_b2);
    double y8 = biquad(y7,f7_v1,f7_v2,f7_a1,f7_a2,gainLP7*f7_b0,gainLP7*f7_b1,gainLP7*f7_b2);

    // EMG 2
    u10 = EMG2.read();
    // Notch
    double y10 = biquad(u10,f3_v3,f3_v4,f3_a1,f3_a2,f3_b0*gainNotch3,f3_b1*gainNotch3,f3_b2*gainNotch3);
    double y12 = biquad(y10,f4_v3,f4_v4,f4_a1,f4_a2,f4_b0*gainNotch4,f4_b1*gainNotch4,f4_b2*gainNotch4);
    double y13 = biquad(y12,f5_v3,f5_v4,f5_a1,f5_a2,f5_b0*gainNotch5,f5_b1*gainNotch5,f5_b2*gainNotch5);

    // HP
    double y14 = biquad(y13,f1_v3,f1_v4,f1_a1,f1_a2,f1_b0*gainHP1,f1_b1*gainHP1,f1_b2*gainHP1);
    double y15 = biquad(y14,f2_v3,f2_v4,f2_a1,f2_a2,f2_b0*gainHP2,f2_b1*gainHP2,f2_b2*gainHP2);

    // LP
    y16 = fabs(y15);
    double y17 = biquad(y16,f6_v3,f6_v4,f6_a1,f6_a2,gainLP6*f6_b0,gainLP6*f6_b1,gainLP6*f6_b2);
    double y18 = biquad(y17,f7_v3,f7_v4,f7_a1,f7_a2,gainLP7*f7_b0,gainLP7*f7_b1,gainLP7*f7_b2);

    if (Cali == true) {
        if (y8 >= Max) {
            Max = y8;
        }
        if (y18 >= Max2) {
            Max2 = y18;
        }
    }
}

void MotorSet()
{
    // Eerst motor 1 (translatie)
    if (OutRange) {
        Error = Goal-Rotatie; // De error die het motortje maakt ten opzichte van je Goal
        Errord = (Error-Errorp)/Fs;
        Errorp = Error;
        if (fabs(Error) <= 0.5) {
            Errori = Errori + Error*1/Fs;
        } else {
            Errori = 0;
        }
        if (Error>=0) {
            Direction=1;
        } else {
            Direction=0;
        }
        v=Kp*Error + Kd*Errord + Ki*Errori;
    }
    PowerMotor.write(fabs(v));

    // Dan motor 2 (rotatie)
    if (OutRange2) {
        Error2 = Goal2-Rotatie2; // De error die het motortje maakt ten opzichte van je Goal
        Errord2 = (Error2-Errorp2)/Fs;
        Errorp2 = Error2;
        if (fabs(Error2) <= 0.5) {
            Errori2 = Errori2 + Error2*1/Fs;
        } else {
            Errori2 = 0;
        }
        if (Error2>=0) {
            Direction2 = 0;
        } else {
            Direction2 = 1;
        }
        v2=Kp2*Error2 + Kd2*Errord2 + Ki2*Errori2;
    }
    PowerMotor2.write(fabs(v2));
}
void Send()
{
    Pulses = Encoder.getPulses();
    Rotatie = (Pulses*twopi)/4200;
    Pulses2 = Encoder2.getPulses();
    Rotatie2 = (Pulses2*twopi)/4200;
    scope.send();
}

int main()
{
    upperlimit = n1*twopi;
    turnlimit = n2*twopi;
    pc.baud(115200);
    PowerMotor.write(0);
    PowerMotor2.write(0);
    Sender.attach(Send,1/Fs);
    MotorWrite.attach(MotorSet,1/Fs);
    biquadTicker.attach(myController,1/Fs2);
    PowerServo.period_ms(20);

    scope.set(0,Goal);
    scope.set(1,Rotatie);
    scope.set(2,emg_value);
    scope.set(3,Goal2);
    scope.set(4,Rotatie2);
    scope.set(5,emg_value2);
    while (true) {
        Encoder.reset();
        Encoder2.reset();
        if (Button == 0) {
            Cali = true;
            TijdEMGCal.start();
        }
        if (TijdEMGCal.read() >= TijdCal) {
            Cali = false;
            TijdEMGCal.stop();
            TijdEMGCal.reset();
            double T1 = 0.2*Max;
            double T2 = 0.5*Max2;
            pc.printf("Max = %f\nT1 = %f\nT2 = %f", Max, T1, T2);
            wait (3);
            Excecute = true;
        }
        while (Excecute) {
            // Eerst wordt motor 1 aangestuurd
            if (Rotatie >= upperlimit) { //Als hij buiten bereik is
                Goal = upperlimit - margin;
                OutRange = true;
            }
            if (Rotatie <= downlimit) { //Als hij buiten bereik is
                Goal = 0 + margin;
                OutRange = true;
            }
            if (Rotatie >= margin && Rotatie <= upperlimit - margin) { // Voor als hij voor het eerst weer binnen bereik is
                OutRange = false;
            }
            if (Rotatie >= downlimit && Rotatie <= upperlimit && OutRange == false) { //EMG aansturing
                if (emg_value >= T2 ) {
                    Direction = 1;
                    v = 0.1;
                }
                if (emg_value > T1 && emg_value < T2) {
                    Direction = 0;
                    v = 0.1;
                }
                if (emg_value <= T1) {
                    Direction = 0;
                    v = 0;
                }
            }

            // Vanaf hier wordt motor 2 aangestuurd
            if (Rotatie2 >= turnlimit) { //Als hij buiten bereik is
                Goal2 = turnlimit;
                OutRange2 = true;
            }
            if (Rotatie2 <= -turnlimit) { //Als hij buiten bereik is
                Goal2 = -turnlimit;
                OutRange2 = true;
            }
            if (Rotatie2 >= -turnlimit && Rotatie2 <= turnlimit) { // Voor als hij voor het eerst weer binnen bereik is
                OutRange2 = false;
            }
            if (Rotatie2 >= -turnlimit && Rotatie2 <= turnlimit && OutRange2 == false) { // EMG aansturing
                if (emg_value2 >= T2 ) {
                    Direction2 = 1;
                    v2 = 0.1;
                }
                if (emg_value2 > T1 && emg_value2 < T2) {
                    Direction2 = 0;
                    v2 = 0.1;
                }
                if (emg_value2 <= T1) {
                    Direction2 = 0;
                    v2 = 0;
                }
            }
            if (Button2 == 0) { //Afvuren van de RBG
                PowerServo.write(0.27);
                wait (1);
                PowerServo.write(0.04);
                Fired=Fired+1;
                pc.printf("Fire = %i", Fired);
                if (Fired == 3) {
                    wait (1);
                    Home = true;
                    Excecute = false;
                }
            }
        }

        while (Home) { //Terugkeren naar vaste positie
            pc.printf("Home\n");
            OutRange = true; //Hiermee wordt het PID gedeelte van de motor control aangestuurd.
            Goal = 0;
            Goal2 = 0;
            if (fabs(Error)<=0.015 && fabs(Error2)<=0.015) {
                timer.start();
            } else {
                timer.stop();
                timer.reset();
            }
            if (timer.read() >= 3) {
                Home = false;
                Errori = 0;
                Errord = 0;
                Errorp = 0;
                Errori2 = 0;
                Errord2 = 0;
                Errorp2 = 0;
                Fired = 0;
            }
        }
    }
}
