#include "mbed.h"
#include "QEI.h"

DigitalOut Direction(D4); //1 = CCW - 0 = CW
PwmOut PowerMotor(D5); //van 0 tot 1
AnalogIn PotMeter(A1);
QEI Encoder(D13,D12,NC,32,QEI::X2_ENCODING); //Encoder
Serial pc(USBTX, USBRX);
Ticker Pot;

double z;

void readpot ()
{
    z = PotMeter.read();
}

int main()
{
    pc.baud(115200);
    PowerMotor.write(0);
    Pot.attach(&readpot,0.1); // Deze ticker moet de waarde uitlezen van de PotMeter 10 keer per seconde
    while (true) {
        pc.printf ("Potmeter = %f\n", z); // het weergeven van de waarde waar z (PotMeter) op dat moment is
    }
}

