/*
 * rosserial Subscriber Example
 * Blinks an LED on callback
 */
#include "mbed.h"
#include <ros.h>
#include <std_msgs/String.h>

ros::NodeHandle nh;
DigitalOut myled(LED1);

std_msgs::String commandRead;
ros::Publisher chatter("chatter", &commandRead);

// /*
void handlerFunction(const std_msgs::String& commandSend){
    commandRead = commandSend;
}
// */

ros::Subscriber<std_msgs::String> sub("cmd_vel", &handlerFunction);

int main() {
    nh.initNode();
    nh.subscribe(sub);
    nh.advertise(chatter);
    
    char initialValue[2] = "X";
    commandRead.data= initialValue;

    while (1) {
        chatter.publish( &commandRead);
        nh.spinOnce();
        wait_ms(10);
    }
}
