/*
 * rosserial Subscriber Example
 * Blinks an LED on callback
 */
#include "mbed.h"
#include <ros.h>
#include <geometry_msgs/Twist.h>

ros::NodeHandle nh;
DigitalOut myled(LED1);

geometry_msgs::Twist commandRead;
ros::Publisher chatter("chatter", &commandRead);

// /*
void handlerFunction(const geometry_msgs::Twist& command){
    commandRead = command;
}
// */

ros::Subscriber<geometry_msgs::Twist> sub("cmd_vel", &handlerFunction);

int main() {
    nh.initNode();
    nh.subscribe(sub);
    nh.advertise(chatter);
    
    commandRead.linear.x = 6.9;

    while (1) {
        //commandRead = command;
        chatter.publish( &commandRead);
        nh.spinOnce();
        wait_ms(10);
    }
}
