#include "mbed.h"
#include "N_5110_Display.h"

// Test program for creating a Dashboard display using the Nokia 5110 84x48 display module for a 'Greenpower' endurance racing car.
// There are simple functions to generate the dashboard annotations and to update the instrument readouts

N_5110_Display Display( p5, p6, p7, p8, p9, p10 );

void doCarDash( void );
void speed( unsigned char value );
void gear( unsigned char value );
void bat( unsigned char value );
void temp( unsigned char value );

//----------------------------------------------------------------------

void doCarDash( void )
// generate the Dashboard layout annotations
{
    Display.setCharPos( 0, 0 );
    Display.printString( "V+", 1, 1 );
    Display.setCharPos( 12, 0 );
    Display.printString( "~C", 1, 1 );
    Display.setCharPos( 4, 0 );
    Display.printString( "MPH", 2, 1 );
    Display.setCharPos( 0, 5 );
    Display.printString( "Gear->  <-Auto", 1, 1 );
    Display.setCharPos( 2, 1 );
    Display.print1char( 'F', 1, 1 );
    Display.setCharPos( 2, 2 );
    Display.print1char( '_', 1, 1 );
    Display.setCharPos( 2, 4 );
    Display.print1char( 'E', 1, 1 );
    Display.setCharPos( 11, 1 );
    Display.print1char( 'H', 1, 1 );
    Display.setCharPos( 11, 2 );
    Display.print1char( '_', 1, 1 );
    Display.setCharPos( 11, 4 );
    Display.print1char( 'C', 1, 1 );
}

//----------------------------------------------------------------------

void speed( unsigned char value )
{
    unsigned char tens, units;
    
    tens = value / 10;
    units = value % 10;
    
    if (tens == 0)                                  //if tens is zero then use blank
    {
        tens = ' ';
    }
    else
    {
        tens = tens + 0x30;                         //otherwise convert to ASCII
    }
    
    if (units == 0)                                 //if units zero then use capital O
    {
        units = 'O';
    }
    else
    {
        units = units + 0x30;                       //otherwise convert to ASCII
    }

    Display.setCharPos( 4, 1 );                     //update the Speed display
    Display.print1char( tens, 3, 4 );
    Display.print1char( units, 3, 4 );
}

void gear( unsigned char value )
{
    Display.setCharPos( 6, 5 );                     //Gear display position
    
    if (value == 0)
    {
        Display.print1char( 'N', 2, 1 );            //if gear zero then use 'N' for neutral
    }
    else if (value > 0 && value < 10)
    {
        Display.print1char( value+0x30, 2, 1 );     //otherwise convert to ASCII
    }
    else
    {
        Display.print1char( 'E', 2, 1 );            //if Gear value greater than 9 (Out of range) then display 'E' for Error
    }
}

void bat( unsigned char percent )
{
    Display.setCharPos( 0, 1 );                     //Left Bar Grapf (Bat)
    Display.VertBarGraph( percent, 2, 4 );
}

void temp( unsigned char percent )
{
    Display.setCharPos( 12, 1 );                    //Right Bar Graph (Temp)
    Display.VertBarGraph( percent, 2, 4 );
}

//---------------------------------------------------------------------

int main()
{
    unsigned char count;

    doCarDash();
    
    for (count=0; count<43; count++)
    {
        temp( count );
        speed( count );
        bat( 99 - count );
        gear( count/11+1 );
    
        wait(0.5);
    }
}
