#include "mbed.h"
#include "kontrolPID.h"
float _kP, _kI, _kD;
float _last_output;
int _interval;
float _limit_Min, _limit_Max;
float _current_Error, _sum_Error, _delta_Error, _previous_Error_1, _previous_Error_2;
float _controller_Output;
kontrolPID::kontrolPID( int interval, 
                        float limit_Min, float limit_Max,
                        float kP, float kI, float kD){
    _kP = kP;
    _kI = kI;
    _kD = kD;
    _interval = interval;
    _limit_Min = limit_Min;
    _limit_Max = limit_Max;
    _last_output = 0;
}
 
void kontrolPID::resetPID(){
    _current_Error = 0;
    _delta_Error = 0;
    _sum_Error = 0;
}
 
float kontrolPID::hitungPID(float _process_Value, float _set_Point){
    float a = _kP + _kI*_interval/2 + _kD/_interval;
    float b = -1*_kP + _kI*_interval/2 - 2*_kD/_interval;
    float c = _kD/_interval;
    
    _current_Error = _set_Point - _process_Value;
    
    _controller_Output = _last_output + a * _current_Error + b * _previous_Error_1 + c * _previous_Error_2;
    
    if (_limit_Max < _controller_Output){
        _controller_Output = _limit_Max;
    }
    else if (_limit_Min > _controller_Output){
        _controller_Output = _limit_Min;
    }
    
    _last_output = _controller_Output;
    _previous_Error_2 = _previous_Error_1;
    _previous_Error_1 = _current_Error;
    
    return _controller_Output;
}
        