#include "XBEE.h"
#include <string>
#include "SwitchCase.h"



XBEE::XBEE(Serial* SerialAddress)
{
    //Serial fish3(PTC17, PTC16);
    cBuffer = new CBuffer(SerialAddress);
    xbeeSerial = SerialAddress;
    
}

bool XBEE::scanForStartBytes()
{
startBytes[0] = 0;
startBytes[1] = 0;
startBytes[2] = 0;    
    
    while(startBytes[0] != STARTBYTE0)
    {
        if(cBuffer->available() <=0){return false;}
        startBytes[0] = cBuffer->read();    
    }
    if(cBuffer->available() <=0){return false;}
    startBytes[1] = cBuffer->read();
    if(startBytes[1] == STARTBYTE1)
        {
        if(cBuffer->available() <=0){return false;}
        startBytes[2] = cBuffer->read(); 
        }
        
     if( (startBytes[0] != STARTBYTE0) || (startBytes[1] != STARTBYTE1) || (startBytes[2] != STARTBYTE2)){return false;}  
    return true;
}


void XBEE::checkForCommand()
{
while(cBuffer->available() > 0)
{
    if(scanForStartBytes() && (cBuffer->available() > 0))
        {
            
          switchCase(cBuffer->read());  
            
        }  
    
    
    
}    
     
}

void XBEE::sendCommand(const char* info)
{
xbeeSerial->putc(STARTBYTE0);
xbeeSerial->putc(STARTBYTE1);
xbeeSerial->putc(STARTBYTE2);
xbeeSerial->putc(STATUSSTRING);    
xbeeSerial->printf(info);    
}
void XBEE::sendCommand(int info)
{
xbeeSerial->putc(STARTBYTE0);
xbeeSerial->putc(STARTBYTE1);
xbeeSerial->putc(STARTBYTE2);
xbeeSerial->putc(STATUSSTRING);    
xbeeSerial->printf("%d",info);    
}

void XBEE::sendCommand(float info)
{
xbeeSerial->putc(STARTBYTE0);
xbeeSerial->putc(STARTBYTE1);
xbeeSerial->putc(STARTBYTE2);
xbeeSerial->putc(STATUSSTRING);    
xbeeSerial->printf("%f",info);    
}

void XBEE::sendCommand(double info)
{
xbeeSerial->putc(STARTBYTE0);
xbeeSerial->putc(STARTBYTE1);
xbeeSerial->putc(STARTBYTE2);
xbeeSerial->putc(STATUSSTRING);    
xbeeSerial->printf("%f",info);    
}
void XBEE::sendCommand(char command, int sizeOfPayload,char payload[])
{
xbeeSerial->putc(STARTBYTE0);
xbeeSerial->putc(STARTBYTE1);
xbeeSerial->putc(STARTBYTE2);
xbeeSerial->putc(command); 
for(int i=0; i<sizeOfPayload; i++)
    {
    xbeeSerial->putc(payload[i]); 
    }
    
}
void XBEE::sendCommand(char command)
{
xbeeSerial->putc(STARTBYTE0);
xbeeSerial->putc(STARTBYTE1);
xbeeSerial->putc(STARTBYTE2);
xbeeSerial->putc(command); 
}

void XBEE::test()
{

    if(cBuffer->available()){xbeeSerial->printf("Receiving The Following Data:\n\r");}
    while(cBuffer->available() > 0){xbeeSerial->putc(cBuffer->read());}
    //xbeeSerial->putc('A');
    

    
}