#include "mbed.h"
#include "CBuffer.h"
#define STARTBYTE0 'Y'
#define STARTBYTE1 'A'
#define STARTBYTE2 'R'

class XBEE{
    public:
XBEE(Serial* SerialAddress); // XBEE comms constructor
void sendCommand(char command, int sizeOfPayload,char payload[]); // Send a command and payload of chars
void sendCommand(char command); // Send a single command byte only
void sendCommand(const char* info); // Send a string to the status box on the laptop
void sendCommand(int info); // Send an int to the status box
void sendCommand(float info); // Send a float to the status box
void sendCommand(double info); // Send a double to the status box
void checkForCommand(); // Reads through the Serial buffer executing any pending commands. call this function regularly to avoid buffer overflow 
void test(); // Test function to test low level comms. This will send "Receiving the following data:" and then mirror back everything currently in the serial buffer
             // Note this function does not use the comms protocol so won't appear on the status text box, you will have to use putty


Serial* xbeeSerial; // Pointer to serial class
CBuffer* cBuffer; // Pointer to circular buffer storing inbound serial data

   private:
bool scanForStartBytes(); // Synchronise comms
void switchCase(char command); // Process inbound commands


char startBytes[3]; // Temp variables to store inbound start bytes for comms synchronisation



};
