#include "mbed.h"
#include "SRF02.h"
#include "N5110.h"
#include "Beep.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"

#define USR_POWERDOWN   (0x104)
int semihost_powerdown()
{

    uint32_t arg;
    return __semihost(USR_POWERDOWN, &arg);

}



//initialise pin
N5110 lcd(p7,p8,p9,p10,p11,p13,p26); //pins used for sensor
SRF02 sensor(p28, p27); //pins used for the range finder sensor
InterruptIn button(p16); // pins used for buttons to change mode
Beep buzzer(p21); //pins used for buzzeer
PwmOut red(p24); //pins for red LED
PwmOut green(p23); //pins for green LED

//variables
int buttonFlag=0;
int distance;
int mode2=0;


//functions to callback
void intro();
void getSensorValue();
void readMode1();
void rangeAction1();
void rangeAction2();
void rangeAction3();
void buttonPressed();
void readMode2();

int main()
{
    PHY_PowerDown();
    int result = semihost_powerdown();

    lcd.init();
    intro(); // to display the intro message
    lcd.clear();

    button.rise(&buttonPressed); // trigger event on rising edge
    while(1) {

        int distance = sensor.getDistanceCm();
        char buffer[14];
        int length = sprintf(buffer,"D= %d cm",distance);
        if(length<=14)
        lcd.printString(buffer,7,3);
        readMode1();
        wait(1);
        lcd.clear();
        lcd.refresh();

        if (buttonFlag) {

            mode2 =~ mode2;
            buttonFlag = 0;
        }

        if (mode2) {
            getSensorValue();
            readMode2();
            lcd.clear();

        }

    }
}

//welcome message (name, id, project name)
void intro()
{

    lcd.printString("Measure Up!",2,0);
    lcd.printString("Nur Faqihah", 2,2);
    lcd.printString("Abd Razak", 2,3);
    lcd.printString("200907347", 2,4);
    lcd.refresh();
    wait (3.0);
}

//to get distance reading from the sensor
void getSensorValue()
{
    distance = sensor.getDistanceCm();
}


// actions for mode 1 based on the disatance range 
void readMode1()
{
    if (distance >= 235) {

        lcd.refresh();
        rangeAction1();

    } else if (distance >= 176 & distance <= 234) {
        lcd.refresh();
        rangeAction1();

    } else if (distance >= 150 & distance <= 175) {
        lcd.refresh();
        rangeAction2();

    } else if (distance >= 135 & distance <= 149) {
        lcd.refresh();
        rangeAction2();

    } else if (distance >= 105 & distance <= 134) {
        lcd.refresh();
        rangeAction2();

    } else if (distance >= 75 & distance <= 104) {
        lcd.refresh();
        rangeAction3();

    } else if (distance >= 46 & distance <= 74) {
        lcd.refresh();
        //rangeAction3();

    } else if (distance <= 45) {
        red = 1;
        buzzer.beep(1000, 60);
    }
}


// actions for mode 2 based on the disatance range 
void readMode2()
{
    if (distance >= 235) {

        lcd.printString("Distance",4,1);
        lcd.printString("Too Long!",6,2);
        lcd.refresh();
        rangeAction1();

    } else if (distance >= 176 & distance <= 234) {

        lcd.printString("Distance",4,1);
        lcd.printString("Too Long!",6,2);
        lcd.refresh();
        rangeAction1();

    } else if (distance >= 150 & distance <= 175) {

        lcd.printString("Distance",4,1);
        lcd.printString("Okay!",2,2);
        lcd.refresh();
        rangeAction2();

    } else if (distance >= 135 & distance <= 149) {

        lcd.printString("Distance",4,1);
        lcd.printString("Okay!",2,2);
        lcd.refresh();
        rangeAction2();

    } else if (distance >= 105 & distance <= 134) {

        lcd.printString("Distance",4,1);
        lcd.printString("Okay!",2,2);
        lcd.refresh();
        rangeAction2();

    } else if (distance >= 75 & distance <= 104) {

        lcd.printString("Distance",4,1);
        lcd.printString("Okay!",2,2);
        lcd.refresh();
        rangeAction2();

    } else if (distance >= 46 & distance <= 74) {

        lcd.printString("Distance",4,1);
        lcd.printString("Too Short!",2,2);
        lcd.refresh();
        rangeAction3();

    } else if (distance <= 45) {

        lcd.printString("Distance",4,1);
        lcd.printString("Too Short!",2,2);
        lcd.refresh();
        red = 1;
        buzzer.beep(1000, 60);
    }
}

//Interrupt Service Routine
void buttonPressed()
{
    buttonFlag = 1;
}

//Actions when range action 1 is achieved
void rangeAction1(){
    
    red = 0;
    green = 1;
    buzzer.beep(1000,0.5);
    wait(1);
    buzzer.nobeep();
    
}

//Actions when range action 2 is achieved
void rangeAction2(){
    
    red = 0;
    green = 0;
    buzzer.beep(1000,1);
    wait(0.5);
    buzzer.nobeep();
    
}

//Actions when range action 3 is achieved
void rangeAction3(){
    
    red = 1;
    green = 0;
    buzzer.beep(1000,0.5);
    wait(0.2);
    buzzer.nobeep();
    
}
    
    
    
    
    
    



