#include "mbed.h"
#include "MSCFileSystem.h"
#include "DHT.h"
#include "TextLCD.h"
Ticker timer_5s;
MSCFileSystem msc("usb"); // Mount flash drive under the name "msc"
Serial pc(USBTX,USBRX);
DigitalOut led(LED1);
DigitalOut rw(p13);
DHT sensor(p10, DHT11);
TextLCD lcd(p12, p14, p15, p16, p17, p18, TextLCD::LCD16x2);


void attime()
{
    led = !led;
}

int main()

{
    rw=0;
    led =0;
    unsigned char data[120*160];                // Test array of data
    timer_5s.attach(&attime, 10);
    int error = 0;
    //float h = 0.0f, c = 0.0f, f = 0.0f, k = 0.0f, dp = 0.0f, dpf = 0.0f;
    float h = 0.0f, c = 0.0f;

    while(1) {
        wait(2.0f);
        error = sensor.readData();
        if (0 == error) {
            c   = sensor.ReadTemperature(CELCIUS);
            h   = sensor.ReadHumidity();
            lcd.locate(0,0);
            lcd.printf("Temp : %4.2f\n", c);
            lcd.locate(0,1);
            lcd.printf("Humid : %4.2f\n", h);
           // lcd.printf("Humidity is %4.2f, Dewpoint: %4.2f, Dewpoint fast: %4.2f\n", h, dp, dpf);
        } else {
            lcd.printf("Error: %d\n", error);
        }
        if (led==1) {
            wait(0.2);
            // Fill the data with values
            for (int i=0; i<120*160; i++) {
                data[i] = 0xAA;                          // Fill array with data
            }

            // Create timers
            // Timer Write_time, Read_time;
            // Write_time.start();

            // Write to local file
            FILE *fp = fopen( "/usb/Mesures.txt", "a");

            for (int i=0; i<1; i++) {
                //fprintf(fp, "%c",data[i]);

                fprintf(fp, "Temp : %4.2f\n - ",c,data[0]);
                fprintf(fp, "Humid : %4.2f\n\r\n", h,data[0]);
            }

            fclose(fp);
            led=0;
        }

    }
    //  Write_time.stop();
    //  pc.printf("\n\rTime taken so write array = %f seconds",Write_time.read());


}