
#include <stdlib.h>
#include <string.h>
#include "sc_types.h"
#include "Default.h"
#include "DefaultRequired.h"
/*! \file Implementation of the state machine 'default'
*/

/* prototypes of all internal functions */
static sc_boolean check_main_region_Functions_tr0_tr0(const Default* handle);
static sc_boolean check_main_region_Functions_tr1_tr1(const Default* handle);
static sc_boolean check_main_region_Functions_tr2_tr2(const Default* handle);
static sc_boolean check_main_region_Functions_tr3_tr3(const Default* handle);
static sc_boolean check_main_region_Functions_tr4_tr4(const Default* handle);
static sc_boolean check_main_region_Menu_tr0_tr0(const Default* handle);
static sc_boolean check_main_region_Menu_tr1_tr1(const Default* handle);
static sc_boolean check_main_region_Menu_tr2_tr2(const Default* handle);
static sc_boolean check_main_region_Menu_tr3_tr3(const Default* handle);
static sc_boolean check_main_region_Ready_tr0_tr0(const Default* handle);
static sc_boolean check_main_region_Function_Selected_tr0_tr0(const Default* handle);
static sc_boolean check_main_region_Function_Selected_tr1_tr1(const Default* handle);
static sc_boolean check_r1_Function_Ready_tr0_tr0(const Default* handle);
static sc_boolean check_r1_Function_Active_tr0_tr0(const Default* handle);
static sc_boolean check_r1_Function_Active_tr1_tr1(const Default* handle);
static sc_boolean check_r1_Alarm_tr0_tr0(const Default* handle);
static sc_boolean check_r1_Alarm_tr1_tr1(const Default* handle);
static sc_boolean check_r1_Move_Down_tr0_tr0(const Default* handle);
static sc_boolean check_r1_Move_Down_tr1_tr1(const Default* handle);
static sc_boolean check_r1_Move_Up_tr0_tr0(const Default* handle);
static sc_boolean check_r1_Move_Up_tr1_tr1(const Default* handle);
static void effect_main_region_Functions_tr0(Default* handle);
static void effect_main_region_Functions_tr1(Default* handle);
static void effect_main_region_Functions_tr2(Default* handle);
static void effect_main_region_Functions_tr3(Default* handle);
static void effect_main_region_Functions_tr4(Default* handle);
static void effect_main_region_Menu_tr0(Default* handle);
static void effect_main_region_Menu_tr1(Default* handle);
static void effect_main_region_Menu_tr2(Default* handle);
static void effect_main_region_Menu_tr3(Default* handle);
static void effect_main_region_Ready_tr0(Default* handle);
static void effect_main_region_Function_Selected_tr0(Default* handle);
static void effect_main_region_Function_Selected_tr1(Default* handle);
static void effect_r1_Function_Ready_tr0(Default* handle);
static void effect_r1_Function_Active_tr0(Default* handle);
static void effect_r1_Function_Active_tr1(Default* handle);
static void effect_r1_Alarm_tr0(Default* handle);
static void effect_r1_Alarm_tr1(Default* handle);
static void effect_r1_Move_Down_tr0(Default* handle);
static void effect_r1_Move_Down_tr1(Default* handle);
static void effect_r1_Move_Up_tr0(Default* handle);
static void effect_r1_Move_Up_tr1(Default* handle);
static void enact_main_region_Functions(Default* handle);
static void enact_main_region_Menu(Default* handle);
static void enact_main_region_Ready(Default* handle);
static void enact_main_region_Function_Selected(Default* handle);
static void enact_r1_Function_Ready(Default* handle);
static void enact_r1_Function_Active(Default* handle);
static void enact_r1_Alarm(Default* handle);
static void enact_r1_Move_Down(Default* handle);
static void enact_r1_Move_Up(Default* handle);
static void exact_r1_Move_Down(Default* handle);
static void exact_r1_Move_Up(Default* handle);
static void enseq_main_region_Functions_default(Default* handle);
static void enseq_main_region_Menu_default(Default* handle);
static void enseq_main_region_Ready_default(Default* handle);
static void enseq_main_region_Function_Selected_default(Default* handle);
static void enseq_r1_Function_Ready_default(Default* handle);
static void enseq_r1_Function_Active_default(Default* handle);
static void enseq_r1_Alarm_default(Default* handle);
static void enseq_r1_Move_Down_default(Default* handle);
static void enseq_r1_Move_Up_default(Default* handle);
static void enseq_main_region_default(Default* handle);
static void enseq_r1_default(Default* handle);
static void exseq_main_region_Functions(Default* handle);
static void exseq_main_region_Menu(Default* handle);
static void exseq_main_region_Ready(Default* handle);
static void exseq_main_region_Function_Selected(Default* handle);
static void exseq_r1_Function_Ready(Default* handle);
static void exseq_r1_Function_Active(Default* handle);
static void exseq_r1_Alarm(Default* handle);
static void exseq_r1_Move_Down(Default* handle);
static void exseq_r1_Move_Up(Default* handle);
static void exseq_main_region(Default* handle);
static void exseq_r1(Default* handle);
static void react_main_region_Functions(Default* handle);
static void react_main_region_Menu(Default* handle);
static void react_main_region_Ready(Default* handle);
static void react_main_region_Function_Selected(Default* handle);
static void react_r1_Function_Ready(Default* handle);
static void react_r1_Function_Active(Default* handle);
static void react_r1_Alarm(Default* handle);
static void react_r1_Move_Down(Default* handle);
static void react_r1_Move_Up(Default* handle);
static void react_main_region__entry_Default(Default* handle);
static void react_r1__entry_Default(Default* handle);
static void clearInEvents(Default* handle);
static void clearOutEvents(Default* handle);


void default_init(Default* handle)
{
		sc_integer i;
	
		for (i = 0; i < DEFAULT_MAX_ORTHOGONAL_STATES; ++i)
		{
			handle->stateConfVector[i] = Default_last_state;
		}
		
		
		handle->stateConfVectorPosition = 0;
	
		clearInEvents(handle);
		clearOutEvents(handle);
	
		/* Default init sequence for statechart default */
		handle->iface.select1 = 0;
		handle->iface.select2 = 0;
		handle->ifaceFunc.t = 0;
}

void default_enter(Default* handle)
{
	/* Default enter sequence for statechart default */
	enseq_main_region_default(handle);
	enseq_r1_default(handle);
}

void default_exit(Default* handle)
{
	/* Default exit sequence for statechart default */
	exseq_main_region(handle);
	exseq_r1(handle);
}

sc_boolean default_isActive(const Default* handle)
{
	sc_boolean result = bool_false;
	int i;
	
	for(i = 0; i < DEFAULT_MAX_ORTHOGONAL_STATES; i++)
	{
		result = result || handle->stateConfVector[i] != Default_last_state;
	}
	
	return result;
}

/* 
 * Always returns 'false' since this state machine can never become final.
 */
sc_boolean default_isFinal(const Default* handle)
{
   return bool_false;
}

static void clearInEvents(Default* handle)
{
	handle->iface.mode_raised = bool_false;
	handle->iface.down_raised = bool_false;
	handle->iface.up_raised = bool_false;
	handle->iface.back_raised = bool_false;
	handle->iface.home_raised = bool_false;
	handle->ifaceFunc.Selected_raised = bool_false;
	handle->ifaceFunc.Deselect_raised = bool_false;
	handle->ifaceFunc.Alarmset_raised = bool_false;
	handle->ifaceFunc.MoveDown_raised = bool_false;
	handle->ifaceFunc.MoveUp_raised = bool_false;
	handle->timeEvents.default_r1_Move_Down_tev0_raised = bool_false;
	handle->timeEvents.default_r1_Move_Up_tev0_raised = bool_false;
}

static void clearOutEvents(Default* handle)
{
}

void default_runCycle(Default* handle)
{
	
	clearOutEvents(handle);
	for (handle->stateConfVectorPosition = 0;
		handle->stateConfVectorPosition < DEFAULT_MAX_ORTHOGONAL_STATES;
		handle->stateConfVectorPosition++)
		{
			
		switch (handle->stateConfVector[handle->stateConfVectorPosition])
		{
		case Default_main_region_Functions:
		{
			react_main_region_Functions(handle);
			break;
		}
		case Default_main_region_Menu:
		{
			react_main_region_Menu(handle);
			break;
		}
		case Default_main_region_Ready:
		{
			react_main_region_Ready(handle);
			break;
		}
		case Default_main_region_Function_Selected:
		{
			react_main_region_Function_Selected(handle);
			break;
		}
		case Default_r1_Function_Ready:
		{
			react_r1_Function_Ready(handle);
			break;
		}
		case Default_r1_Function_Active:
		{
			react_r1_Function_Active(handle);
			break;
		}
		case Default_r1_Alarm:
		{
			react_r1_Alarm(handle);
			break;
		}
		case Default_r1_Move_Down:
		{
			react_r1_Move_Down(handle);
			break;
		}
		case Default_r1_Move_Up:
		{
			react_r1_Move_Up(handle);
			break;
		}
		default:
			break;
		}
	}
	
	clearInEvents(handle);
}

void default_raiseTimeEvent(const Default* handle, sc_eventid evid)
{
	if ( ((sc_intptr_t)evid) >= ((sc_intptr_t)&(handle->timeEvents))
		&&  ((sc_intptr_t)evid) < ((sc_intptr_t)&(handle->timeEvents)) + sizeof(DefaultTimeEvents))
		{
		*(sc_boolean*)evid = bool_true;
	}		
}

sc_boolean default_isStateActive(const Default* handle, DefaultStates state)
{
	sc_boolean result = bool_false;
	switch (state)
	{
		case Default_main_region_Functions :
			result = (sc_boolean) (handle->stateConfVector[SCVI_DEFAULT_MAIN_REGION_FUNCTIONS] == Default_main_region_Functions
			);
			break;
		case Default_main_region_Menu :
			result = (sc_boolean) (handle->stateConfVector[SCVI_DEFAULT_MAIN_REGION_MENU] == Default_main_region_Menu
			);
			break;
		case Default_main_region_Ready :
			result = (sc_boolean) (handle->stateConfVector[SCVI_DEFAULT_MAIN_REGION_READY] == Default_main_region_Ready
			);
			break;
		case Default_main_region_Function_Selected :
			result = (sc_boolean) (handle->stateConfVector[SCVI_DEFAULT_MAIN_REGION_FUNCTION_SELECTED] == Default_main_region_Function_Selected
			);
			break;
		case Default_r1_Function_Ready :
			result = (sc_boolean) (handle->stateConfVector[SCVI_DEFAULT_R1_FUNCTION_READY] == Default_r1_Function_Ready
			);
			break;
		case Default_r1_Function_Active :
			result = (sc_boolean) (handle->stateConfVector[SCVI_DEFAULT_R1_FUNCTION_ACTIVE] == Default_r1_Function_Active
			);
			break;
		case Default_r1_Alarm :
			result = (sc_boolean) (handle->stateConfVector[SCVI_DEFAULT_R1_ALARM] == Default_r1_Alarm
			);
			break;
		case Default_r1_Move_Down :
			result = (sc_boolean) (handle->stateConfVector[SCVI_DEFAULT_R1_MOVE_DOWN] == Default_r1_Move_Down
			);
			break;
		case Default_r1_Move_Up :
			result = (sc_boolean) (handle->stateConfVector[SCVI_DEFAULT_R1_MOVE_UP] == Default_r1_Move_Up
			);
			break;
		default:
			result = bool_false;
			break;
	}
	return result;
}

void defaultIface_raise_mode(Default* handle)
{
	handle->iface.mode_raised = bool_true;
}
void defaultIface_raise_down(Default* handle)
{
	handle->iface.down_raised = bool_true;
}
void defaultIface_raise_up(Default* handle)
{
	handle->iface.up_raised = bool_true;
}
void defaultIface_raise_back(Default* handle)
{
	handle->iface.back_raised = bool_true;
}
void defaultIface_raise_home(Default* handle)
{
	handle->iface.home_raised = bool_true;
}


sc_integer defaultIface_get_select1(const Default* handle)
{
	return handle->iface.select1;
}
void defaultIface_set_select1(Default* handle, sc_integer value)
{
	handle->iface.select1 = value;
}
sc_integer defaultIface_get_select2(const Default* handle)
{
	return handle->iface.select2;
}
void defaultIface_set_select2(Default* handle, sc_integer value)
{
	handle->iface.select2 = value;
}
void defaultIfaceFunc_raise_selected(Default* handle)
{
	handle->ifaceFunc.Selected_raised = bool_true;
}
void defaultIfaceFunc_raise_deselect(Default* handle)
{
	handle->ifaceFunc.Deselect_raised = bool_true;
}
void defaultIfaceFunc_raise_alarmset(Default* handle)
{
	handle->ifaceFunc.Alarmset_raised = bool_true;
}
void defaultIfaceFunc_raise_moveDown(Default* handle)
{
	handle->ifaceFunc.MoveDown_raised = bool_true;
}
void defaultIfaceFunc_raise_moveUp(Default* handle)
{
	handle->ifaceFunc.MoveUp_raised = bool_true;
}


sc_integer defaultIfaceFunc_get_t(const Default* handle)
{
	return handle->ifaceFunc.t;
}
void defaultIfaceFunc_set_t(Default* handle, sc_integer value)
{
	handle->ifaceFunc.t = value;
}

/* implementations of all internal functions */

static sc_boolean check_main_region_Functions_tr0_tr0(const Default* handle)
{
	return handle->iface.back_raised;
}

static sc_boolean check_main_region_Functions_tr1_tr1(const Default* handle)
{
	return handle->iface.down_raised;
}

static sc_boolean check_main_region_Functions_tr2_tr2(const Default* handle)
{
	return ((handle->iface.up_raised) && (handle->iface.select2 > 1)) ? bool_true : bool_false;
}

static sc_boolean check_main_region_Functions_tr3_tr3(const Default* handle)
{
	return handle->iface.home_raised;
}

static sc_boolean check_main_region_Functions_tr4_tr4(const Default* handle)
{
	return handle->iface.mode_raised;
}

static sc_boolean check_main_region_Menu_tr0_tr0(const Default* handle)
{
	return handle->iface.down_raised;
}

static sc_boolean check_main_region_Menu_tr1_tr1(const Default* handle)
{
	return ((handle->iface.up_raised) && (handle->iface.select1 > 1)) ? bool_true : bool_false;
}

static sc_boolean check_main_region_Menu_tr2_tr2(const Default* handle)
{
	return handle->iface.back_raised;
}

static sc_boolean check_main_region_Menu_tr3_tr3(const Default* handle)
{
	return handle->iface.mode_raised;
}

static sc_boolean check_main_region_Ready_tr0_tr0(const Default* handle)
{
	return handle->iface.mode_raised;
}

static sc_boolean check_main_region_Function_Selected_tr0_tr0(const Default* handle)
{
	return handle->iface.back_raised;
}

static sc_boolean check_main_region_Function_Selected_tr1_tr1(const Default* handle)
{
	return handle->iface.home_raised;
}

static sc_boolean check_r1_Function_Ready_tr0_tr0(const Default* handle)
{
	return handle->ifaceFunc.Selected_raised;
}

static sc_boolean check_r1_Function_Active_tr0_tr0(const Default* handle)
{
	return handle->ifaceFunc.Deselect_raised;
}

static sc_boolean check_r1_Function_Active_tr1_tr1(const Default* handle)
{
	return handle->ifaceFunc.Alarmset_raised;
}

static sc_boolean check_r1_Alarm_tr0_tr0(const Default* handle)
{
	return handle->ifaceFunc.MoveDown_raised;
}

static sc_boolean check_r1_Alarm_tr1_tr1(const Default* handle)
{
	return handle->ifaceFunc.MoveUp_raised;
}

static sc_boolean check_r1_Move_Down_tr0_tr0(const Default* handle)
{
	return (handle->ifaceFunc.t == 0) ? bool_true : bool_false;
}

static sc_boolean check_r1_Move_Down_tr1_tr1(const Default* handle)
{
	return ((handle->timeEvents.default_r1_Move_Down_tev0_raised) && (handle->ifaceFunc.t > 0)) ? bool_true : bool_false;
}

static sc_boolean check_r1_Move_Up_tr0_tr0(const Default* handle)
{
	return (handle->ifaceFunc.t == 0) ? bool_true : bool_false;
}

static sc_boolean check_r1_Move_Up_tr1_tr1(const Default* handle)
{
	return ((handle->timeEvents.default_r1_Move_Up_tev0_raised) && (handle->ifaceFunc.t > 0)) ? bool_true : bool_false;
}

static void effect_main_region_Functions_tr0(Default* handle)
{
	exseq_main_region_Functions(handle);
	enseq_main_region_Menu_default(handle);
}

static void effect_main_region_Functions_tr1(Default* handle)
{
	exseq_main_region_Functions(handle);
	handle->iface.select2 += 1;
	enseq_main_region_Functions_default(handle);
}

static void effect_main_region_Functions_tr2(Default* handle)
{
	exseq_main_region_Functions(handle);
	handle->iface.select2 -= 1;
	enseq_main_region_Functions_default(handle);
}

static void effect_main_region_Functions_tr3(Default* handle)
{
	exseq_main_region_Functions(handle);
	enseq_main_region_Ready_default(handle);
}

static void effect_main_region_Functions_tr4(Default* handle)
{
	exseq_main_region_Functions(handle);
	defaultIface_function(handle, handle->iface.select2);
	enseq_main_region_Function_Selected_default(handle);
}

static void effect_main_region_Menu_tr0(Default* handle)
{
	exseq_main_region_Menu(handle);
	handle->iface.select1 += 1;
	enseq_main_region_Menu_default(handle);
}

static void effect_main_region_Menu_tr1(Default* handle)
{
	exseq_main_region_Menu(handle);
	handle->iface.select1 -= 1;
	enseq_main_region_Menu_default(handle);
}

static void effect_main_region_Menu_tr2(Default* handle)
{
	exseq_main_region_Menu(handle);
	enseq_main_region_Ready_default(handle);
}

static void effect_main_region_Menu_tr3(Default* handle)
{
	exseq_main_region_Menu(handle);
	defaultIface_menu(handle, handle->iface.select1);
	handle->iface.select2 = 1;
	enseq_main_region_Functions_default(handle);
}

static void effect_main_region_Ready_tr0(Default* handle)
{
	exseq_main_region_Ready(handle);
	handle->iface.select1 = 1;
	enseq_main_region_Menu_default(handle);
}

static void effect_main_region_Function_Selected_tr0(Default* handle)
{
	exseq_main_region_Function_Selected(handle);
	enseq_main_region_Functions_default(handle);
}

static void effect_main_region_Function_Selected_tr1(Default* handle)
{
	exseq_main_region_Function_Selected(handle);
	enseq_main_region_Ready_default(handle);
}

static void effect_r1_Function_Ready_tr0(Default* handle)
{
	exseq_r1_Function_Ready(handle);
	enseq_r1_Function_Active_default(handle);
}

static void effect_r1_Function_Active_tr0(Default* handle)
{
	exseq_r1_Function_Active(handle);
	enseq_r1_Function_Ready_default(handle);
}

static void effect_r1_Function_Active_tr1(Default* handle)
{
	exseq_r1_Function_Active(handle);
	enseq_r1_Alarm_default(handle);
}

static void effect_r1_Alarm_tr0(Default* handle)
{
	exseq_r1_Alarm(handle);
	enseq_r1_Move_Down_default(handle);
}

static void effect_r1_Alarm_tr1(Default* handle)
{
	exseq_r1_Alarm(handle);
	enseq_r1_Move_Up_default(handle);
}

static void effect_r1_Move_Down_tr0(Default* handle)
{
	exseq_r1_Move_Down(handle);
	defaultIfaceFunc_return(handle);
	enseq_r1_Function_Active_default(handle);
}

static void effect_r1_Move_Down_tr1(Default* handle)
{
	exseq_r1_Move_Down(handle);
	defaultIfaceFunc_moveDownAct(handle);
	handle->ifaceFunc.t -= 1;
	enseq_r1_Move_Down_default(handle);
}

static void effect_r1_Move_Up_tr0(Default* handle)
{
	exseq_r1_Move_Up(handle);
	defaultIfaceFunc_return(handle);
	enseq_r1_Function_Active_default(handle);
}

static void effect_r1_Move_Up_tr1(Default* handle)
{
	exseq_r1_Move_Up(handle);
	defaultIfaceFunc_moveUpAct(handle);
	handle->ifaceFunc.t -= 1;
	enseq_r1_Move_Up_default(handle);
}

/* Entry action for state 'Functions'. */
static void enact_main_region_Functions(Default* handle)
{
	/* Entry action for state 'Functions'. */
	defaultIface_function(handle, handle->iface.select2);
}

/* Entry action for state 'Menu'. */
static void enact_main_region_Menu(Default* handle)
{
	/* Entry action for state 'Menu'. */
	defaultIface_menu(handle, handle->iface.select1);
}

/* Entry action for state 'Ready'. */
static void enact_main_region_Ready(Default* handle)
{
	/* Entry action for state 'Ready'. */
	handle->iface.select1 = 0;
	handle->iface.select2 = 0;
}

/* Entry action for state 'Function Selected'. */
static void enact_main_region_Function_Selected(Default* handle)
{
	/* Entry action for state 'Function Selected'. */
	defaultIface_execute(handle);
}

/* Entry action for state 'Function Ready'. */
static void enact_r1_Function_Ready(Default* handle)
{
	/* Entry action for state 'Function Ready'. */
	defaultIfaceFunc_ready(handle);
}

/* Entry action for state 'Function Active'. */
static void enact_r1_Function_Active(Default* handle)
{
	/* Entry action for state 'Function Active'. */
	defaultIfaceFunc_active(handle);
}

/* Entry action for state 'Alarm'. */
static void enact_r1_Alarm(Default* handle)
{
	/* Entry action for state 'Alarm'. */
	handle->ifaceFunc.t = 15;
}

/* Entry action for state 'Move Down'. */
static void enact_r1_Move_Down(Default* handle)
{
	/* Entry action for state 'Move Down'. */
	default_setTimer(handle, (sc_eventid) &(handle->timeEvents.default_r1_Move_Down_tev0_raised) , 1 * 1000, bool_true);
	defaultIfaceFunc_moveDownAct(handle);
}

/* Entry action for state 'Move Up'. */
static void enact_r1_Move_Up(Default* handle)
{
	/* Entry action for state 'Move Up'. */
	default_setTimer(handle, (sc_eventid) &(handle->timeEvents.default_r1_Move_Up_tev0_raised) , 1 * 1000, bool_true);
	defaultIfaceFunc_moveUpAct(handle);
}

/* Exit action for state 'Move Down'. */
static void exact_r1_Move_Down(Default* handle)
{
	/* Exit action for state 'Move Down'. */
	default_unsetTimer(handle, (sc_eventid) &(handle->timeEvents.default_r1_Move_Down_tev0_raised) );		
}

/* Exit action for state 'Move Up'. */
static void exact_r1_Move_Up(Default* handle)
{
	/* Exit action for state 'Move Up'. */
	default_unsetTimer(handle, (sc_eventid) &(handle->timeEvents.default_r1_Move_Up_tev0_raised) );		
}

/* 'default' enter sequence for state Functions */
static void enseq_main_region_Functions_default(Default* handle)
{
	/* 'default' enter sequence for state Functions */
	enact_main_region_Functions(handle);
	handle->stateConfVector[0] = Default_main_region_Functions;
	handle->stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state Menu */
static void enseq_main_region_Menu_default(Default* handle)
{
	/* 'default' enter sequence for state Menu */
	enact_main_region_Menu(handle);
	handle->stateConfVector[0] = Default_main_region_Menu;
	handle->stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state Ready */
static void enseq_main_region_Ready_default(Default* handle)
{
	/* 'default' enter sequence for state Ready */
	enact_main_region_Ready(handle);
	handle->stateConfVector[0] = Default_main_region_Ready;
	handle->stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state Function Selected */
static void enseq_main_region_Function_Selected_default(Default* handle)
{
	/* 'default' enter sequence for state Function Selected */
	enact_main_region_Function_Selected(handle);
	handle->stateConfVector[0] = Default_main_region_Function_Selected;
	handle->stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state Function Ready */
static void enseq_r1_Function_Ready_default(Default* handle)
{
	/* 'default' enter sequence for state Function Ready */
	enact_r1_Function_Ready(handle);
	handle->stateConfVector[1] = Default_r1_Function_Ready;
	handle->stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state Function Active */
static void enseq_r1_Function_Active_default(Default* handle)
{
	/* 'default' enter sequence for state Function Active */
	enact_r1_Function_Active(handle);
	handle->stateConfVector[1] = Default_r1_Function_Active;
	handle->stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state Alarm */
static void enseq_r1_Alarm_default(Default* handle)
{
	/* 'default' enter sequence for state Alarm */
	enact_r1_Alarm(handle);
	handle->stateConfVector[1] = Default_r1_Alarm;
	handle->stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state Move Down */
static void enseq_r1_Move_Down_default(Default* handle)
{
	/* 'default' enter sequence for state Move Down */
	enact_r1_Move_Down(handle);
	handle->stateConfVector[1] = Default_r1_Move_Down;
	handle->stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state Move Up */
static void enseq_r1_Move_Up_default(Default* handle)
{
	/* 'default' enter sequence for state Move Up */
	enact_r1_Move_Up(handle);
	handle->stateConfVector[1] = Default_r1_Move_Up;
	handle->stateConfVectorPosition = 1;
}

/* 'default' enter sequence for region main region */
static void enseq_main_region_default(Default* handle)
{
	/* 'default' enter sequence for region main region */
	react_main_region__entry_Default(handle);
}

/* 'default' enter sequence for region r1 */
static void enseq_r1_default(Default* handle)
{
	/* 'default' enter sequence for region r1 */
	react_r1__entry_Default(handle);
}

/* Default exit sequence for state Functions */
static void exseq_main_region_Functions(Default* handle)
{
	/* Default exit sequence for state Functions */
	handle->stateConfVector[0] = Default_last_state;
	handle->stateConfVectorPosition = 0;
}

/* Default exit sequence for state Menu */
static void exseq_main_region_Menu(Default* handle)
{
	/* Default exit sequence for state Menu */
	handle->stateConfVector[0] = Default_last_state;
	handle->stateConfVectorPosition = 0;
}

/* Default exit sequence for state Ready */
static void exseq_main_region_Ready(Default* handle)
{
	/* Default exit sequence for state Ready */
	handle->stateConfVector[0] = Default_last_state;
	handle->stateConfVectorPosition = 0;
}

/* Default exit sequence for state Function Selected */
static void exseq_main_region_Function_Selected(Default* handle)
{
	/* Default exit sequence for state Function Selected */
	handle->stateConfVector[0] = Default_last_state;
	handle->stateConfVectorPosition = 0;
}

/* Default exit sequence for state Function Ready */
static void exseq_r1_Function_Ready(Default* handle)
{
	/* Default exit sequence for state Function Ready */
	handle->stateConfVector[1] = Default_last_state;
	handle->stateConfVectorPosition = 1;
}

/* Default exit sequence for state Function Active */
static void exseq_r1_Function_Active(Default* handle)
{
	/* Default exit sequence for state Function Active */
	handle->stateConfVector[1] = Default_last_state;
	handle->stateConfVectorPosition = 1;
}

/* Default exit sequence for state Alarm */
static void exseq_r1_Alarm(Default* handle)
{
	/* Default exit sequence for state Alarm */
	handle->stateConfVector[1] = Default_last_state;
	handle->stateConfVectorPosition = 1;
}

/* Default exit sequence for state Move Down */
static void exseq_r1_Move_Down(Default* handle)
{
	/* Default exit sequence for state Move Down */
	handle->stateConfVector[1] = Default_last_state;
	handle->stateConfVectorPosition = 1;
	exact_r1_Move_Down(handle);
}

/* Default exit sequence for state Move Up */
static void exseq_r1_Move_Up(Default* handle)
{
	/* Default exit sequence for state Move Up */
	handle->stateConfVector[1] = Default_last_state;
	handle->stateConfVectorPosition = 1;
	exact_r1_Move_Up(handle);
}

/* Default exit sequence for region main region */
static void exseq_main_region(Default* handle)
{
	/* Default exit sequence for region main region */
	/* Handle exit of all possible states (of default.main_region) at position 0... */
	switch(handle->stateConfVector[ 0 ])
	{
		case Default_main_region_Functions :
		{
			exseq_main_region_Functions(handle);
			break;
		}
		case Default_main_region_Menu :
		{
			exseq_main_region_Menu(handle);
			break;
		}
		case Default_main_region_Ready :
		{
			exseq_main_region_Ready(handle);
			break;
		}
		case Default_main_region_Function_Selected :
		{
			exseq_main_region_Function_Selected(handle);
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region r1 */
static void exseq_r1(Default* handle)
{
	/* Default exit sequence for region r1 */
	/* Handle exit of all possible states (of default.r1) at position 1... */
	switch(handle->stateConfVector[ 1 ])
	{
		case Default_r1_Function_Ready :
		{
			exseq_r1_Function_Ready(handle);
			break;
		}
		case Default_r1_Function_Active :
		{
			exseq_r1_Function_Active(handle);
			break;
		}
		case Default_r1_Alarm :
		{
			exseq_r1_Alarm(handle);
			break;
		}
		case Default_r1_Move_Down :
		{
			exseq_r1_Move_Down(handle);
			break;
		}
		case Default_r1_Move_Up :
		{
			exseq_r1_Move_Up(handle);
			break;
		}
		default: break;
	}
}

/* The reactions of state Functions. */
static void react_main_region_Functions(Default* handle)
{
	/* The reactions of state Functions. */
	if (check_main_region_Functions_tr0_tr0(handle) == bool_true)
	{ 
		effect_main_region_Functions_tr0(handle);
	}  else
	{
		if (check_main_region_Functions_tr1_tr1(handle) == bool_true)
		{ 
			effect_main_region_Functions_tr1(handle);
		}  else
		{
			if (check_main_region_Functions_tr2_tr2(handle) == bool_true)
			{ 
				effect_main_region_Functions_tr2(handle);
			}  else
			{
				if (check_main_region_Functions_tr3_tr3(handle) == bool_true)
				{ 
					effect_main_region_Functions_tr3(handle);
				}  else
				{
					if (check_main_region_Functions_tr4_tr4(handle) == bool_true)
					{ 
						effect_main_region_Functions_tr4(handle);
					} 
				}
			}
		}
	}
}

/* The reactions of state Menu. */
static void react_main_region_Menu(Default* handle)
{
	/* The reactions of state Menu. */
	if (check_main_region_Menu_tr0_tr0(handle) == bool_true)
	{ 
		effect_main_region_Menu_tr0(handle);
	}  else
	{
		if (check_main_region_Menu_tr1_tr1(handle) == bool_true)
		{ 
			effect_main_region_Menu_tr1(handle);
		}  else
		{
			if (check_main_region_Menu_tr2_tr2(handle) == bool_true)
			{ 
				effect_main_region_Menu_tr2(handle);
			}  else
			{
				if (check_main_region_Menu_tr3_tr3(handle) == bool_true)
				{ 
					effect_main_region_Menu_tr3(handle);
				} 
			}
		}
	}
}

/* The reactions of state Ready. */
static void react_main_region_Ready(Default* handle)
{
	/* The reactions of state Ready. */
	if (check_main_region_Ready_tr0_tr0(handle) == bool_true)
	{ 
		effect_main_region_Ready_tr0(handle);
	} 
}

/* The reactions of state Function Selected. */
static void react_main_region_Function_Selected(Default* handle)
{
	/* The reactions of state Function Selected. */
	if (check_main_region_Function_Selected_tr0_tr0(handle) == bool_true)
	{ 
		effect_main_region_Function_Selected_tr0(handle);
	}  else
	{
		if (check_main_region_Function_Selected_tr1_tr1(handle) == bool_true)
		{ 
			effect_main_region_Function_Selected_tr1(handle);
		} 
	}
}

/* The reactions of state Function Ready. */
static void react_r1_Function_Ready(Default* handle)
{
	/* The reactions of state Function Ready. */
	if (check_r1_Function_Ready_tr0_tr0(handle) == bool_true)
	{ 
		effect_r1_Function_Ready_tr0(handle);
	} 
}

/* The reactions of state Function Active. */
static void react_r1_Function_Active(Default* handle)
{
	/* The reactions of state Function Active. */
	if (check_r1_Function_Active_tr0_tr0(handle) == bool_true)
	{ 
		effect_r1_Function_Active_tr0(handle);
	}  else
	{
		if (check_r1_Function_Active_tr1_tr1(handle) == bool_true)
		{ 
			effect_r1_Function_Active_tr1(handle);
		} 
	}
}

/* The reactions of state Alarm. */
static void react_r1_Alarm(Default* handle)
{
	/* The reactions of state Alarm. */
	if (check_r1_Alarm_tr0_tr0(handle) == bool_true)
	{ 
		effect_r1_Alarm_tr0(handle);
	}  else
	{
		if (check_r1_Alarm_tr1_tr1(handle) == bool_true)
		{ 
			effect_r1_Alarm_tr1(handle);
		} 
	}
}

/* The reactions of state Move Down. */
static void react_r1_Move_Down(Default* handle)
{
	/* The reactions of state Move Down. */
	if (check_r1_Move_Down_tr0_tr0(handle) == bool_true)
	{ 
		effect_r1_Move_Down_tr0(handle);
	}  else
	{
		if (check_r1_Move_Down_tr1_tr1(handle) == bool_true)
		{ 
			effect_r1_Move_Down_tr1(handle);
		} 
	}
}

/* The reactions of state Move Up. */
static void react_r1_Move_Up(Default* handle)
{
	/* The reactions of state Move Up. */
	if (check_r1_Move_Up_tr0_tr0(handle) == bool_true)
	{ 
		effect_r1_Move_Up_tr0(handle);
	}  else
	{
		if (check_r1_Move_Up_tr1_tr1(handle) == bool_true)
		{ 
			effect_r1_Move_Up_tr1(handle);
		} 
	}
}

/* Default react sequence for initial entry  */
static void react_main_region__entry_Default(Default* handle)
{
	/* Default react sequence for initial entry  */
	enseq_main_region_Ready_default(handle);
}

/* Default react sequence for initial entry  */
static void react_r1__entry_Default(Default* handle)
{
	/* Default react sequence for initial entry  */
	enseq_r1_Function_Ready_default(handle);
}



