#include "files.h"

#if (MBED_MAJOR_VERSION == 2)
    #include    "SDFileSystem.h"
#elif (MBED_MAJOR_VERSION == 5)
    #include    "SDBlockDevice.h"
    #include    "FATFileSystem.h"
#endif

#if (MBED_MAJOR_VERSION == 2)
    SDFileSystem    sd(D11, D12, D13, D10, "fs");  // do,di,clk,cs
#elif (MBED_MAJOR_VERSION == 5)
    //SDBlockDevice   sd(D11, D12, D13, D10, 8000000);
    SDBlockDevice   sd(SPI0_MOSI, SPI0_MISO, SPI0_SCK, SPI0_SS, 8000000);    // For MAX32630FTHR 
    FATFileSystem   fs("fs");
#endif


int totaFunctionlFiles = 0;
int functionFileNumber = 1;
int functionActive = 0;
extern int functionPosition = 0;
Function ffunc;

int initSDCard(){
#if (MBED_MAJOR_VERSION == 5)
    /* Init SD CARD reader */
    sd.init();
    fs.mount(&sd);
#endif
    FILE* fp = fopen("/fs/mydata.txt", "a");
    if (fp != 0) {
        pc.printf("writing something\n\r\n");
        fprintf(fp,"writing something\n\r\n");
    } else {
        pc.printf("ERROR\r\n");
    }
    fclose(fp);
    return 0;
}

int readFileNames(){
    DIR *d;
    struct dirent *p;

    d = opendir("/fs/functions");
    if (d != NULL) {
        while ((p = readdir(d)) != NULL) {
//            printf(" - %s\n", p->d_name);
            totaFunctionlFiles++;
        }
    } else {
        printf("Could not open directory!\n");
    }
    closedir(d);
    printf("Total files = %d\n", totaFunctionlFiles);
    return 0;
}

int navFunctionFiles(int direction){

    if(direction == DIR_UP){
        if(functionFileNumber < totaFunctionlFiles){
            functionFileNumber++;
        }else{
            functionFileNumber = 1;
        }
        printf("UP: %d\n", functionFileNumber);
    }else{
        if(functionFileNumber > 1){
            functionFileNumber--;
        }else{
            functionFileNumber = totaFunctionlFiles;
        }
        printf("DOWN: %d\n", functionFileNumber);
    }
    return 0;
}

int openFunctionFile(int inpFile){
    char fileLoc [40];
    sprintf (fileLoc, "/fs/functions/function%d.txt", inpFile);
    printf ("[%s] is location %d file number\n", fileLoc, inpFile);

    FILE* fp = fopen(fileLoc, "r");    
    ffunc.pos=0;
    while (fscanf(fp, "%d,%d", &ffunc.x[ffunc.pos], &ffunc.t[ffunc.pos]) != EOF){
        ffunc.pos++;
    }

    fclose(fp);
    functionActive = 1;
    functionPosition = 0;
    printFunctionData();
    return 0;
}

void printFunctionData(){
    printf ("total: %d\n", ffunc.pos);    
    for(int i=0; i<ffunc.pos; i++ ){
        printf ("%d, %d\n", ffunc.x[i], ffunc.t[i]);
    }
}

