
#ifndef DEFAULT_H_
#define DEFAULT_H_

#include "sc_types.h"
		
#ifdef __cplusplus
extern "C" { 
#endif 

/*! \file Header of the state machine 'default'.
*/


/*! Enumeration of all states */ 
typedef enum
{
	Default_last_state,
	Default_main_region_Functions,
	Default_main_region_Menu,
	Default_main_region_Ready,
	Default_main_region_Function_Selected,
	Default_r1_Function_Ready,
	Default_r1_Function_Active,
	Default_r1_Alarm,
	Default_r1_Move_Down,
	Default_r1_Move_Up
} DefaultStates;

/*! Type definition of the data structure for the DefaultIface interface scope. */
typedef struct
{
	sc_boolean mode_raised;
	sc_boolean down_raised;
	sc_boolean up_raised;
	sc_boolean back_raised;
	sc_boolean home_raised;
	sc_integer select1;
	sc_integer select2;
} DefaultIface;

/*! Type definition of the data structure for the DefaultIfaceFunc interface scope. */
typedef struct
{
	sc_boolean Selected_raised;
	sc_boolean Deselect_raised;
	sc_boolean Alarmset_raised;
	sc_boolean MoveDown_raised;
	sc_boolean MoveUp_raised;
	sc_integer t;
} DefaultIfaceFunc;

/*! Type definition of the data structure for the DefaultTimeEvents interface scope. */
typedef struct
{
	sc_boolean default_r1_Move_Down_tev0_raised;
	sc_boolean default_r1_Move_Up_tev0_raised;
} DefaultTimeEvents;


/*! Define dimension of the state configuration vector for orthogonal states. */
#define DEFAULT_MAX_ORTHOGONAL_STATES 2

/*! Define maximum number of time events that can be active at once */
#define DEFAULT_MAX_PARALLEL_TIME_EVENTS 1

/*! Define indices of states in the StateConfVector */
#define SCVI_DEFAULT_MAIN_REGION_FUNCTIONS 0
#define SCVI_DEFAULT_MAIN_REGION_MENU 0
#define SCVI_DEFAULT_MAIN_REGION_READY 0
#define SCVI_DEFAULT_MAIN_REGION_FUNCTION_SELECTED 0
#define SCVI_DEFAULT_R1_FUNCTION_READY 1
#define SCVI_DEFAULT_R1_FUNCTION_ACTIVE 1
#define SCVI_DEFAULT_R1_ALARM 1
#define SCVI_DEFAULT_R1_MOVE_DOWN 1
#define SCVI_DEFAULT_R1_MOVE_UP 1

/*! 
 * Type definition of the data structure for the Default state machine.
 * This data structure has to be allocated by the client code. 
 */
typedef struct
{
	DefaultStates stateConfVector[DEFAULT_MAX_ORTHOGONAL_STATES];
	sc_ushort stateConfVectorPosition; 
	
	DefaultIface iface;
	DefaultIfaceFunc ifaceFunc;
	DefaultTimeEvents timeEvents;
} Default;


/*! Initializes the Default state machine data structures. Must be called before first usage.*/
extern void default_init(Default* handle);

/*! Activates the state machine */
extern void default_enter(Default* handle);

/*! Deactivates the state machine */
extern void default_exit(Default* handle);

/*! Performs a 'run to completion' step. */
extern void default_runCycle(Default* handle);

/*! Raises a time event. */
extern void default_raiseTimeEvent(const Default* handle, sc_eventid evid);

/*! Raises the in event 'mode' that is defined in the default interface scope. */ 
extern void defaultIface_raise_mode(Default* handle);

/*! Raises the in event 'down' that is defined in the default interface scope. */ 
extern void defaultIface_raise_down(Default* handle);

/*! Raises the in event 'up' that is defined in the default interface scope. */ 
extern void defaultIface_raise_up(Default* handle);

/*! Raises the in event 'back' that is defined in the default interface scope. */ 
extern void defaultIface_raise_back(Default* handle);

/*! Raises the in event 'home' that is defined in the default interface scope. */ 
extern void defaultIface_raise_home(Default* handle);

/*! Gets the value of the variable 'select1' that is defined in the default interface scope. */ 
extern sc_integer defaultIface_get_select1(const Default* handle);
/*! Sets the value of the variable 'select1' that is defined in the default interface scope. */ 
extern void defaultIface_set_select1(Default* handle, sc_integer value);
/*! Gets the value of the variable 'select2' that is defined in the default interface scope. */ 
extern sc_integer defaultIface_get_select2(const Default* handle);
/*! Sets the value of the variable 'select2' that is defined in the default interface scope. */ 
extern void defaultIface_set_select2(Default* handle, sc_integer value);
/*! Raises the in event 'Selected' that is defined in the interface scope 'Func'. */ 
extern void defaultIfaceFunc_raise_selected(Default* handle);

/*! Raises the in event 'Deselect' that is defined in the interface scope 'Func'. */ 
extern void defaultIfaceFunc_raise_deselect(Default* handle);

/*! Raises the in event 'Alarmset' that is defined in the interface scope 'Func'. */ 
extern void defaultIfaceFunc_raise_alarmset(Default* handle);

/*! Raises the in event 'MoveDown' that is defined in the interface scope 'Func'. */ 
extern void defaultIfaceFunc_raise_moveDown(Default* handle);

/*! Raises the in event 'MoveUp' that is defined in the interface scope 'Func'. */ 
extern void defaultIfaceFunc_raise_moveUp(Default* handle);

/*! Gets the value of the variable 't' that is defined in the interface scope 'Func'. */ 
extern sc_integer defaultIfaceFunc_get_t(const Default* handle);
/*! Sets the value of the variable 't' that is defined in the interface scope 'Func'. */ 
extern void defaultIfaceFunc_set_t(Default* handle, sc_integer value);

/*!
 * Checks whether the state machine is active (until 2.4.1 this method was used for states).
 * A state machine is active if it was entered. It is inactive if it has not been entered at all or if it has been exited.
 */
extern sc_boolean default_isActive(const Default* handle);

/*!
 * Checks if all active states are final. 
 * If there are no active states then the state machine is considered being inactive. In this case this method returns false.
 */
extern sc_boolean default_isFinal(const Default* handle);

/*! Checks if the specified state is active (until 2.4.1 the used method for states was called isActive()). */
extern sc_boolean default_isStateActive(const Default* handle, DefaultStates state);



#ifdef __cplusplus
}
#endif 

#endif /* DEFAULT_H_ */

