#include "mbed.h"
#include "max32630fthr.h"
#include "USBSerial.h"
#include "Default.h"
#include "DefaultRequired.h"
#include  <stdlib.h>
#include "main.h"
#include "files.h"
#include "IMU.h"
#include "RTClock.h"

MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
Serial _serialport(USBTX,USBRX);
DigitalOut LED(P3_1);
DigitalOut Ctrl(P6_0);

DigitalOut rLED(LED1);
DigitalOut gLED(LED2);


void Rx_interrupt(void);

Default default_SM;
bool is_smactive;

// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
int main()
{
    _serialport.attach(&Rx_interrupt);
    gLED = LED_ON;
    rLED = LED_ON;


//    _serialport.printf("before init\r\n");

    if(initSDCard() == 0) {
        _serialport.printf("SD init OK!\n");
    }

    if(initIMU() == 0) {
        _serialport.printf("IMU init OK!\n");
    }

    //readFileNames();
    //initRTC();

    /* initialize state machine*/
    default_init(&default_SM);
    default_enter(&default_SM);
    is_smactive = false;

    while(1) {
        if(is_smactive == true) {
            // _serialport.printf("state active\n");
            is_smactive = false;
            default_runCycle(&default_SM);
        }
    }
}

/* Call back from Interrupt when Receiving Serial data*/

void Rx_interrupt(void)
{
    char keypress = '\0';
    keypress = _serialport.getc();
    /**Actions on received data*/
    switch(keypress) {
        default:
            break;

        case 'Q':
            // _serialport.printf("Q");
            defaultIface_raise_mode(&default_SM);
            is_smactive = true;
            break;

        case 'W':
            //_serialport.printf("W ");
            defaultIface_raise_up(&default_SM);
            is_smactive = true;
            break;

        case 'E':
            //_serialport.printf("E ");
            defaultIface_raise_down(&default_SM);
            is_smactive = true;
            break;

        case 'R':
            //_serialport.printf("R ");
            defaultIface_raise_back(&default_SM);
            is_smactive = true;
            break;

        case 'T':
            //_serialport.printf("T ");
            defaultIface_raise_home(&default_SM);
            is_smactive = true;
            break;
    }

}

void PrintStatus_Serial(int val )
{
    switch(val) {
        case 1:
            _serialport.printf("Menu ");
            break;

        case 2:
            _serialport.printf("function ");
            break;

        case 3:
            _serialport.printf("execute ");
            break;

        case 4:
            _serialport.printf("ready\n");
            break;

        case 5:
            _serialport.printf("active\n");
            break;

        case 6:
            _serialport.printf("alarm\n");
            break;

        case 7:
            _serialport.printf("move down act\n");
            break;

        case 8:
            _serialport.printf("move up act\n");
            break;

        case 9:
            _serialport.printf("return\n");
            break;

        default:
            break;
    }

}
