#ifndef MESSAGELOGGER_H
#define MESSAGELOGGER_H

#include "mbed.h"
#include "rtos.h"

#include <string>
#include <sstream>
#include <iostream>

class MessageLogger
{    
    public:
        MessageLogger();
       
        void SendError(string errorMessage);
        void SendMessage(char* message);
        bool GetError();
        bool GetMessage();
        void SetThread(Thread* logger);
        
    private:
        Thread* loggingThread;
        ostringstream fatalError;
        int messageCount;
        bool hasError;
        osStatus stat;
        char c;
        Mutex messageLock;
        
        void PrintError();
        void PrintMessage();
};
#endif