#include "Message.h"

/**
    @file :     Message.cpp
    @authors :   Radu Marcu, Jacob Williams, Niall Francis, Arron Burch
    
    @section DESCRIPTION
    
    This is the Message class, which is used by the MessageLogger to pass messages into the mail box
    awaiting printing by the logger. The Message class is also used by the MessageLogger to get the
    contents of the mail box back out to be printed.
*/


/**
    Copies the content from ptr into the Message object text char array.
    
    @param ptr :    Pointer to char array containing message.
*/
void Message::copy(char* ptr)
{
    strncpy(text, ptr, 256);
}

/**
    @return text :  Returns the text char array stored in Message object.
*/
char* Message::getText()
{
    return text;
}