#include "Measure.h"


/**
    @file :     Measure.cpp
    @authors :   Radu Marcu, Jacob Williams, Niall Francis, Arron Burch
    
    @section DESCRIPTION
    
    This is the Measure class. Each message object stores the values collected from
    the sensor board (temperature, humidity, pressure). These objects are later
    stored in the CircularArray.
*/



//
// Measure objects holding data collected from sensor board.
//

Measure::Measure(float f, float h, float p) {
    temperature = f;
    humidity = h;
    pressure = p;    
}

Measure::Measure()
{
    temperature = 0;
    humidity = 0;
    pressure = 0;    
}

Measure::Measure(LocalDate d,float f, float h, float p)
{
    date = d;
    temperature = f;
    humidity = h;
    pressure = p;   
}
