#include "FakeSensor.h"
#include "mbed.h"
 
 /**
    @file :     FakeMeasurer.cpp
    @authors :   Radu Marcu, Jacob Williams, Niall Francis, Arron Burch
    
    @section DESCRIPTION
    
    This is the FakeMeasurer class. It is used to generate fake data readings,
    meant to simulate the results a real sensor would provide. It generates random
    values for humidity and temperature.
*/
 
 
 
/**       
    Constructor
    Takes in minimum and maximum values for both temperature and humidity fake readings
    
    @param tempMin :    Miniumum value for temperature.
    @param tempMax :    Maxiumum value for temperature.
    @param humiMin :    Miniumum value for humidity.
    @param humiMax :    Maxiumum value for humidity.
*/
FakeMeasurer::FakeMeasurer(float tempMin, float tempMax, float humiMin, float humiMax)
{
    temperatureMin = tempMin;
    temperatureMax = tempMax;
    humidityMin = humiMin;
    humidityMax = humiMax;
}   
 
/**
    @return :   True to fake successful initialisation of sensor.
*/   
bool FakeMeasurer::init() 
{
    return true;
}

/**
    Fakes a calibration call to the sensor by doing nothing.
*/
void FakeMeasurer::calib() {}

/** 
    Generates a random number for both temperature and humidity using the ranges
    given in the constructor and stores the random numbers in the variables passed in.
    
    @param temperature :    Pointer to float where temperature reading is stored.
    @param humidity :    Pointer to float where humidity reading is stored.
*/
void FakeMeasurer::ReadTempHumi(float *temperature, float *humidity)
{
    int rangeMax = 1000;
            
    float targetRange = temperatureMax - temperatureMin;
    srand(time(NULL));
    int randNum = (rand()%rangeMax);
    float perc = (float)randNum / rangeMax;
    float percRange = perc * targetRange;
    *temperature = percRange + temperatureMin;   
            
    targetRange = humidityMax - humidityMin;
    srand(time(NULL));
    randNum = (rand()%rangeMax);
    perc = (float)randNum / rangeMax;
    percRange = perc * targetRange;
    *humidity = percRange + humidityMin;                
}