#include "FakeSensor.h"
#include "mbed.h"

/**
    @file :     FakeBarometer.cpp
    @authors :   Radu Marcu, Jacob Williams, Niall Francis, Arron Burch
    
    @section DESCRIPTION
    
    This is the FakeBarometer class. It is used to generate fake data readings,
    meant to simulate the results a real sensor would provide. It generates random
    values for pressure.
*/




/**
    Constructor
    Takes in minimum and maximum values for fake pressure readings
    
    @param pressMin :   Minimum value for pressure.
    @param pressMax :   Maximum value for pressure.
*/
FakeBarometer::FakeBarometer(float pressMin, float pressMax)
{
    pressureMin = pressMin;
    pressureMax = pressMax;
}

/**
    Fakes a get call to the sensor by doing nothing.
*/
void FakeBarometer::get() {}

/**
    Generates a random number for pressure using the range given in the constructor
    
    @return actual :    The random number generated, simulating pressure.
*/
float FakeBarometer::pressure()
{
    int rangeMax = 1000;
    float targetRange = pressureMax - pressureMin;
    srand(time(NULL));
    int randNum = (rand()%rangeMax);
    float perc = (float)randNum / rangeMax;
    float percRange = perc * targetRange;
    float actual = percRange + pressureMin;
    return actual;
}
        