#include "LocalDate.h"
#include <stdio.h>

/**
    @file :     LocalDate.cpp
    @authors :   Radu Marcu, Jacob Williams, Niall Francis, Arron Burch
    
    @section DESCRIPTION
    
    This is class is the LocalDate class, reponsible for handling the date and
    time. It allows for the date and time to be set during run time, and automatically
    updates the time every second. The class also allows the date to be returned to 
    areas of the program.
*/


LocalDate::LocalDate(int d, int m, int y,int h,int mm,int s)
{
    day = d;
    month = m;
    year = y;   
    hour = h;
    min = mm;
    sec = s;
}

LocalDate::LocalDate()
{
    day = 12;
    month = 12;
    year = 2012;   
    hour = 12;
    min = 12;
    sec = 12;
}

LocalDate::LocalDate(LocalDate *localDate)
{
    day = localDate->day;
    month = localDate->month;
    year = localDate->year;
    hour = localDate->hour;
    min = localDate->min;
    sec = localDate->sec;   
}

/**
    Sets values to passed in localDate object.
    
    @param localDate :  LocalDate object storing data.
*/
void LocalDate::setValues(LocalDate *localDate)
{        
    day = localDate->day;
    month = localDate->month;
    year = localDate->year;
    hour = localDate->hour;
    min = localDate->min;
    sec = localDate->sec;  
}

/**
    Takes data stored in LocalDate objects and formats it.
    
    @return charArray :     Char array containing formatted data to be printed.
*/
char* LocalDate::ToString()
{
    char *charArray = new char[40];
    snprintf(charArray, 256, "%i/%i/%i, %i:%i:%i",day,month,year,hour,min,sec);
    return charArray;
}

/**
    Increases time stored in object by one second, calculating the new time.
*/
void LocalDate::TickSecond()
{
    sec++;
    if(sec == 60)
    {
        sec=0;
        min++;   
        if(min==60)
        {
        
            min = 0;
            hour++;
        
            if(hour ==24)
            {
                hour = 0;
                day++;
                
                if(day ==31)
                {
                    day = 0;
                    month++;
                    if(month==13)   
                    {
                        month = 1;
                        year++;   
                    }
                }
            }
        }
    }
}
