/**
    Represents a fake barometer
    Holds a min and max pressure as a range for fake pressure readings
    Also holds pseudo methods as copies of the original barometers
*/
class FakeBarometer
{
    public:
        float pressureMin;
        float pressureMax;
        
        // Constructor
        FakeBarometer(float pressMin, float pressMax);
        
        void get();
        float pressure();
};

/**
    Represents a fake measurer
    Holds a min and max temperature and humidity as ranges for the fake readings
    Also holds pseudo methods as copies of the original sensor methods
*/
class FakeMeasurer
{
    public:
        float temperatureMin;
        float temperatureMax;
        float humidityMin;
        float humidityMax;
        
        FakeMeasurer(float tempMin, float tempMax, float humiMin, float humiMax);
        
        bool init();
        void calib();
        void ReadTempHumi(float *temperature, float *humidity);
};