#include "mbed.h"
#include "MQTTEthernet.h"
#include "MQTTClient.h"
#include <sstream>
#include <string>

Serial s(PA_13,PA_14); // Communication with the Arduino Board

Serial out(USBTX,USBRX);  // Debuging through USB

void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    out.printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\n", message.qos, message.retained, message.dup, message.id);
    out.printf("Payload %.*s\n", message.payloadlen, (char*)message.payload);
    s.printf("%.*s\n", message.payloadlen, (char*)message.payload);//To send serial data to arduino
    int    i = atoi((char*)message.payload);
    switch(i) {
        case 0:   //start servo to feed the fish
            out.printf("Feeding");
            s.printf("Feed");
            break;
        case 1:    //turn lights on
            out.printf("Lights on");
            s.printf("ON");

            break;
        case 2:    //turn lights off
            out.printf("Lights off");
            s.printf("OFF");

            break;
        case 3:    //turn Dancing led strip on
            out.printf("Led Flashing");
            s.printf("Dance");

            break;
        case 4:    //turn Dancing led strip off
            out.printf("Led Not Flashing");
            s.printf("NoDance");

            break;

    }
}

void baud(int baudrate)
{

    s.baud(baudrate);
}




int main(void)
{

    char* topic1 = "******/feeds/welcome-feed";
    // char* topic2 = "******/feeds/lights";        //******  type your username on IFTT instead of the stars 
    //char* topic3 = "******/feeds/dance";

    printf("starting...\n");


    MQTTEthernet ipstack = MQTTEthernet();

    MQTT::Client<MQTTEthernet, Countdown> client = MQTT::Client<MQTTEthernet, Countdown>(ipstack);

    char* hostname = "io.adafruit.com";//your MQTT broker host
    int port = 1883; // broker port number

    int rc = ipstack.connect(hostname, port);

    out.printf("rc from TCP connect is %d\n", rc);

    if (rc != 0)
        out.printf("rc from TCP connect is %d\n", rc);

    char MQTTClientID[30];
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    sprintf(MQTTClientID,"WIZwiki-%d",rand()%1000);

    data.clientID.cstring = MQTTClientID;
    data.username.cstring = "*******";   //******  type your username on IFTT instead of the stars
    data.password.cstring = "************************";   //******  type your Password on IFTT instead of the stars
    if ((rc = client.connect(data)) != 0)
        printf("rc from MQTT connect is %d\n", rc);


    if ((rc = client.subscribe(topic1, MQTT::QOS0, messageArrived)) != 0) {
        out.printf("rc from MQTT subscribe is %d\n", rc);


    }

    while (true) {



        client.yield(6);

    }
}