/*
 *******************************************************************************
 * Пример работы экранной клавиатуры на демо-плате STM32F746NG Discovery с
 * использованием стандартного набора библиотек BSP и пользовательской
 * библиотеки "keyboard.h"
 *******************************************************************************
 */

/* Добавляем библиотеку для работы с LCD */
#include "stm32746g_discovery_lcd.h"

/* Добавляем библиотеку экранной клавиатуры */
#include "keyboard.h"

/* Вспомогательные переменые */
uint8_t i;
uint8_t key;
uint8_t len;

/* Пользовательский буфер */
char buffer[45];

/* Основная программа */
int main(void)
{
    /* Инициализация дисплея */
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(0, LCD_FB_START_ADDRESS);
    BSP_LCD_LayerDefaultInit(1, LCD_FB_START_ADDRESS + (BSP_LCD_GetXSize() * BSP_LCD_GetYSize() * 4));

    /* Включаем дисплей */
    BSP_LCD_DisplayOn();

    /* Настраиваем первый и второй слои дисплея */
    BSP_LCD_SelectLayer(0);
    BSP_LCD_Clear(LCD_COLOR_WHITE);
    BSP_LCD_SelectLayer(1);
    BSP_LCD_Clear(LCD_COLOR_BLACK);
    BSP_LCD_SetTransparency(0, 0);
    BSP_LCD_SetTransparency(1, 100);

    /* Настраиваем цвет фона экрана и цвет текста, а также шрифт  */
    BSP_LCD_SetTextColor(LCD_COLOR_LIGHTGREEN);
    BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
    BSP_LCD_SetFont(&Font16);

    /* Инициализация тач-экрана*/
    BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize());
    
    /* Инициализация клавиатуры */
    Keyboard_init(0, 80);
    
    /* Основной цикл */
    while(1) 
    {
        /* Вызываем обработчик экранной клавиатуры */
        key = Keyboard_handler(buffer);
        
        /* Если последней нажатой клавишей был "Enter", значит, пользовательский
         * ввод завершен и его можно как-то обработать
         */
        if (key == KEY_ENTER_VALUE)
        {
            /* Пользовательская реализация обработки ввода должна быть тут */
            
            /* Затираем строчку со старым буфером и отображаем новый */
            BSP_LCD_ClearStringLine(1);
            BSP_LCD_DisplayStringAtLine(1, (uint8_t *) buffer);
            buffer[0] = '\0';
        }
        
        /* Задержка на 10 мс */
        HAL_Delay(10);
    }
}