/*
 * app.cpp
 * 
 * Copyright 2017 Faberge@TsarTeam
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 */
 
#include "app.h"
 
/* Screen functions */

void createSwitchScreen(Screen *scr)
{
    scr -> reset(LCD_COLOR_BLACK);
    scr -> add(new Textbox(320, 5, LCD_COLOR_BLACK, "Switch Demo"));
              
    /* Create switches */
    scr -> add(new Switch(10, 20, LCD_COLOR_BLUE, toggleBlueLED));
    scr -> add(new Switch(10, 100, LCD_COLOR_RED, toggleRedLED));
    scr -> add(new Switch(10, 180, LCD_COLOR_ORANGE, toggleOrangeLED));
    scr -> add(new Switch(10, 260, LCD_COLOR_GREEN, toggleGreenLED));

    scr -> exitOnWithCode(new Button(10, 390, LCD_COLOR_DARKCYAN, "BTN"), NEW_BUTTON_SCREEN);
    scr -> exitOnWithCode(new Button(720, 390, LCD_COLOR_DARKCYAN, "TEXT"), NEW_TEXT_SCREEN);

    HAL_Delay(300);
}

void createButtonScreen(Screen *scr)
{
    scr -> reset(LCD_COLOR_BLACK);
    scr -> add(new Textbox(320, 5, LCD_COLOR_BLACK, "Button Demo"));

    /* Create buttons */
    scr -> add(new Button(10, 20, LCD_COLOR_BLUE, "LED", toggleBlueLED));
    scr -> add(new Button(10, 100, LCD_COLOR_RED, "LED", toggleRedLED));
    scr -> add(new Button(10, 180, LCD_COLOR_ORANGE, "LED", toggleOrangeLED));
    scr -> add(new Button(10, 260, LCD_COLOR_GREEN, "LED", toggleGreenLED));

    scr -> exitOnWithCode(new Button(10, 390, LCD_COLOR_DARKCYAN, "TEXT"), NEW_TEXT_SCREEN);
    scr -> exitOnWithCode(new Button(720, 390, LCD_COLOR_DARKCYAN, "SWCH"), NEW_SWITCH_SCREEN);

    HAL_Delay(300);
}

void createTextScreen(Screen *scr)
{
    scr -> reset(LCD_COLOR_BLACK);
    scr -> add(new Textbox(340, 5, LCD_COLOR_BLACK, "Text Demo"));

    /* Create textboxes */
    scr -> add(new Textbox(10, 20, LCD_COLOR_BLACK, "Some text"));
    scr -> add(new Textbox(10, 40, LCD_COLOR_BLACK, "Some more text..."));
    scr -> add(new Textbox(10, 60, LCD_COLOR_BLACK, "This demo brought"));
    scr -> add(new Textbox(10, 80, LCD_COLOR_BLACK, "to you by Faberge"));

    scr -> exitOnWithCode(new Button(10, 390, LCD_COLOR_DARKCYAN, "SWCH"), NEW_SWITCH_SCREEN);
    scr -> exitOnWithCode(new Button(720, 390, LCD_COLOR_DARKCYAN, "BTN"), NEW_BUTTON_SCREEN);

    HAL_Delay(300);
}
 