/*
 * Switch.h
 * 
 * Copyright 2017 Faberge@TsarTeam
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 */

#ifndef SWITCH_H
#define SWITCH_H

#include "Widget.h"
#include "Button.h"

class Switch : public Widget
{
    public:
        /* Fade Widget's color when pressed */
        static const uint32_t FADEMASK = 0xFF666666;
        static const uint16_t DIMX = (Button::DIMX) * 2 + 4;
        static const uint16_t DIMY = Button::DIMY;
        
        /* Initial state of Switch is "OFF" */
        Switch(const uint16_t x, const uint16_t y, const color_t clr, 
            void (*fOne) (), void (*fTwo) ()) :
            Widget(x, y, DIMX, DIMY, clr), b1(x, y, clr & FADEMASK, "ON"), 
            b2(x + Button::DIMX + 4, y, clr, "OFF"), funcOne(fOne), funcTwo(fTwo), 
            fBool(NULL), state(false) {}
        Switch(const uint16_t x, const uint16_t y, const color_t clr, 
            void (*func) (bool)) :
            Widget(x, y, DIMX, DIMY, clr), b1(x, y, clr & FADEMASK, "ON"),
            b2(x + Button::DIMX + 4, y, clr, "OFF"), funcOne(NULL), funcTwo(NULL),
            fBool(func), state(false) {}
            
        virtual ~Switch();
        virtual void draw(color_t clr);
        virtual uint16_t update();
        
    private:
        /* Switch consists of two Buttons */
        Button b1;
        Button b2;
        
        void (*funcOne) ();
        void (*funcTwo) ();
        void (*fBool) (bool);
        
        bool state;
};

#endif