/*
 * Switch.cpp
 * 
 * Copyright 2017 Faberge@TsarTeam
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 */


#include "Switch.h"

Switch :: ~Switch()
{
    if (funcTwo != NULL)
        funcTwo();
    if (fBool != NULL)
        fBool(false);
}

void Switch :: draw(color_t clr)
{
    if (state == false)
    {
        b1.draw(clr & FADEMASK);
        b2.draw(clr);
    }
    if (state == true)
    {
        b1.draw(clr);
        b2.draw(clr & FADEMASK);
    }
}

uint16_t Switch :: update()
{
    if ((state == false) && b1.isTouched())
    {
        state = true;
        draw(backColor);
        if (funcOne != NULL)
            funcOne();
        if (fBool != NULL)
            fBool(state);
    }
    if ((state == true) && b2.isTouched())
    {
        state = false;
        draw(backColor);
        if (funcTwo != NULL)
            funcTwo();
        if (fBool != NULL)
            fBool(state);
    }
    
    return state;
}