/*
 * Screen.cpp
 * 
 * Copyright 2017 Faberge@TsarTeam
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 */


#include "Screen.h"

Screen :: Screen(color_t clr) : Widget(0, 0,  DIMX, DIMY, clr)
{
    /* Start a new screen */
    LCD.clear(backColor);
}

void Screen :: rst(color_t clr)
{        
    /* Delete all Widgets */
    for (int i = 0; i < vPair.size(); i++)
        delete vPair[i].first;
    vPair.clear();
    
    /* Reset Screen */
    LCD.clear(backColor);
}

uint16_t Screen :: update()
{
    /* If Widget is active and has a non-zero OpCode,
     * then we can exit this screen with this OpCode
     */
    for (int i = 0; i < vPair.size(); i++)
        if (vPair[i].first -> update() && vPair[i].second != 0)
            return vPair[i].second;
    
    return 0;
}
