/*
 * LCD_F469.h
 * 
 * Copyright 2017 Faberge@TsarTeam
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 */
 
#ifndef LCD_F469_H
#define LCD_F469_H

#include "stm32469i_discovery_lcd.h"

typedef uint32_t color_t;
typedef Text_AlignModeTypdef text_mode_t;

class Display
{           
    public:        
        Display();
        
        /* Set colors */
        void setTextColor(color_t color) {BSP_LCD_SetTextColor(color);}
        void setBackColor(color_t color) {BSP_LCD_SetBackColor(color);}
        
        /* Clear display */
        void clear(color_t color) {BSP_LCD_Clear(color);}
        
        /* Display strings */
        void displayStringAtLine(uint16_t line, char *str) 
            {BSP_LCD_DisplayStringAtLine(line, (uint8_t *) str);}
        void clearStringAtLine(uint16_t line) {BSP_LCD_ClearStringLine(line);}
        void displayStringAt(uint16_t x, uint16_t y, char *str, text_mode_t tm = LEFT_MODE)
            {BSP_LCD_DisplayStringAt(x, y, (uint8_t *) str, tm);}
        void setFont(sFONT *fonts) {BSP_LCD_SetFont(fonts);}
        
        void fillRect(uint16_t x, uint16_t y, uint16_t width, uint16_t height)
            {BSP_LCD_FillRect(x, y, width, height);}
};

#endif
