/*
 * Widget.cpp
 * 
 * Copyright 2017 Faberge@TsarTeam
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 */

#include "Widget.h"

Display Widget :: LCD;
TouchScreen Widget :: TS;

bool Widget :: isTouched()
{
    if (TS.getState())
    {
        uint16_t x = TS.getX();
        uint16_t y = TS.getY();
        
        /* Actual size a little bigger */
        if (( x >= xPos - 2) && (x <= xPos + xDim + 2) &&
                (y >= yPos - 2) && (y <= yPos + yDim + 2))
            return true; 
    }
    
    return false;
}

Widget :: ~Widget() {}
uint16_t Widget :: update() {return 0;}
 