/*
 * Screen.h
 * 
 * Copyright 2017 Faberge@TsarTeam
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 */

#ifndef SCREEN_H
#define SCREEN_H

#include <vector>
#include "Widget.h"

class Screen : private Widget
{
    private:
        static const uint16_t DIMX = 800;
        static const uint16_t DIMY = 480;
        
        std::vector<Widget*> widgets;
        std::vector<std::pair <Widget*, uint16_t> > vPair;
        
        void rst(color_t clr);
        
        
    public:
        Screen(color_t clr);
        virtual ~Screen() {rst(backColor);}
    
        void reset(color_t clr) {rst(backColor);}
        void add(Widget *w) {exitOnWithCode(w, 0);}
        void exitOnWithCode(Widget *w, uint16_t opCode)
            {vPair.push_back(std::make_pair(w, opCode));}
            
        virtual uint16_t update();
};

#endif