/*
 * Button.h
 * 
 * Copyright 2017 Faberge@TsarTeam
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 */

#ifndef BUTTON_H
#define BUTTON_H

#include "Widget.h"

class Button : public Widget
{    
    public:
        /* Fade Widget's color when pressed */
        static const uint32_t FADEMASK = 0xFF666666;
        static const uint16_t DIMX = 70;
        static const uint16_t DIMY = 70;
    
        /* Initial state of Button is "OFF" */
        Button(const uint16_t x, const uint16_t y, const color_t clr, char *s) : 
            Widget(x, y, DIMX, DIMY, clr), str(s), funcOne(NULL), funcTwo(NULL), 
            fBool(NULL), state(false) {draw(backColor);}
        Button(const uint16_t x, const uint16_t y, const color_t clr, char *s, 
            void (*fOne) (), void (*fTwo) ()) :
            Widget(x, y, DIMX, DIMY, clr), str(s), funcOne(fOne), funcTwo(fTwo),
            fBool(NULL), state(false) {draw(backColor);}
        Button(const uint16_t x, const uint16_t y, const color_t clr, char *s,
            void (*func) (bool)):
            Widget(x, y, DIMX, DIMY, clr), str(s), funcOne(NULL), funcTwo(NULL),
            fBool(func), state(false) {draw(backColor);}
            
        virtual ~Button();
        virtual void draw(color_t clr);
        virtual uint16_t update();
    
    private:    
        char *str;
        
        void (*funcOne) ();
        void (*funcTwo) ();
        void (*fBool) (bool);
                
        bool state;   
};

#endif
