/*
 * Button.cpp
 * 
 * Copyright 2017 Faberge@TsarTeam
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 */

#include "Button.h"

Button :: ~Button()
{
    if (funcTwo != NULL)
        funcTwo();
    if (fBool != NULL)
        fBool(false);
}

void Button :: draw(color_t clr)
{
    LCD.setTextColor(clr);
    LCD.fillRect(xPos, yPos, xDim, yDim);
    
    uint16_t len = strlen(str); 
    if (len != 0)
    {
        LCD.setBackColor(clr);
        LCD.setTextColor(textColor);
        LCD.setFont(&Font24);
        
        uint16_t x = xPos + (xDim - (Font24.Width) * len) / 2 + 1;
        uint16_t y = yPos + (yDim - (Font24.Height)) / 2;
        
        LCD.displayStringAt(x, y, str);
    }
}

uint16_t Button :: update()
{
    if ((state == false) && isTouched())
    {
        state = true;
        draw(backColor & FADEMASK);
        if (funcOne != NULL)
            funcOne();
        if (fBool != NULL)
            fBool(state);
    }
    if ((state == true) && !isTouched())
    {
        state = false;
        draw(backColor);
        if (funcTwo != NULL)
            funcTwo();
        if (fBool != NULL)
            fBool(state);
    }
    
    return state;
}
