/*
 * main.cpp
 * 
 * Copyright 2017 Faberge@TsarTeam
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 */

#include "app.h"

int main()
{
    /* Init LEDs */
    InitLEDs();
    
    /* Dummy screen */
    Screen scr(LCD_COLOR_BLACK);
    /* Program state */
    int state = NEW_TEXT_SCREEN;
    
    while(1)
    {
      /* Create screens */
      switch(state)
      {
          case NEW_SWITCH_SCREEN:
          {
              createSwitchScreen(&scr);
              break;
          }
          case NEW_BUTTON_SCREEN:
          {
              createButtonScreen(&scr);
              break;
          }
          case NEW_TEXT_SCREEN:
          {
              createTextScreen(&scr);
              break;
          }
          default: break;
      }
      /* Check and upadte */
      state = scr.update();
      
      /* Small delay for stability */
      HAL_Delay(10);
    }
}

