/*
 * Widget.h
 * 
 * Copyright 2017 Faberge@TsarTeam
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 */

#ifndef WIDGET_H
#define WIDGET_H

#include "LCD_F469.h"
#include "TS_F469.h"

class Widget
{    
    private:
    
    protected:
        Widget(const uint16_t x, const uint16_t y, const uint16_t width, 
            const uint16_t height, const color_t backClr, 
            const color_t textClr = LCD_COLOR_WHITE) :
            xPos(x), yPos(y), xDim(width), yDim(height), 
            backColor(backClr), textColor(textClr) {}
        
        const uint16_t xPos;
        const uint16_t yPos;
        const uint16_t xDim;
        const uint16_t yDim;
        
        const color_t backColor;
        const color_t textColor;
        
        static Display LCD;
        static TouchScreen TS;
        
    public:
        virtual ~Widget() = 0;
        bool isTouched();
        virtual void draw(color_t clr) {};
        virtual uint16_t update();
        
};

#endif