/*
 * Textbox.h
 * 
 * Copyright 2017 Faberge@TsarTeam
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 */
 
#ifndef TEXTBOX_H
#define TEXTBOX_H 
 
#include "Widget.h"

class Textbox : public Widget
{
    public:
        static const uint16_t DIMX = 0;
        static const uint16_t DIMY = 0;
        
        Textbox(const uint16_t x, const uint16_t y, const color_t clr, 
            char *s = "", text_mode_t tm = LEFT_MODE) :
            Widget(x, y, DIMX, DIMY, clr), str(s), mode(tm) {draw(backColor);}
            
        virtual void draw(color_t clr);
        virtual uint16_t update() {return 0;};
    
    private:
        char * str;
        text_mode_t mode;
};

#endif