#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <math.h>
#include <iostream>
#include "an_packet_protocol.h"
#include "spatial_packets.h"
#include "mbed.h"

#define M_PI 3.14
#define RADIANS_TO_DEGREES (180.0/M_PI)

 
Serial pc(USBTX, USBRX); // tx, rx
Serial device(p9, p10);  // tx, rx
 
int main() {
    
    an_decoder_t an_decoder;
    an_packet_t *an_packet;
    
    system_state_packet_t system_state_packet;

    an_decoder_initialise(&an_decoder);
    pc.baud(115200);
    device.baud(115200);    

      while(1) {
            
             // an_decoder.buffer_length = 0;
      while(device.readable()) {
                //pc.printf("%d\r\n",sizeof(an_decoder.buffer));
                //j = device.readable() ;
                int i = an_decoder.buffer_length;
                an_decoder.buffer[i+1] = device.getc();
                an_decoder_increment(&an_decoder, 1);
                //pc.printf("%d\r\n",(an_decoder.buffer_length));
            }
            
            /* iterate through an example data dump from spatial */
            if (40<an_decoder.buffer_length)
            { 
            
                //calculate the number of bytes to copy
                //bytes_to_copy = an_decoder_size(&an_decoder);
                
                while ((an_packet = an_packet_decode(&an_decoder)) != NULL)
                {   
                    //an_packet = an_packet_decode(&an_decoder);
                                        
                    if (an_packet->id == packet_id_system_state) //system state packet 
                    {  
        
                        //copy all the binary data into the typedef struct for the packet 
                        //this allows easy access to all the different values             
                        if (decode_system_state_packet(&system_state_packet, an_packet) == 0)
                        {
                            pc.printf("System State Packet:\n");
                            pc.printf("\tLatitude = %f, Longitude = %f, Height = %f\n", system_state_packet.latitude * RADIANS_TO_DEGREES, system_state_packet.longitude * RADIANS_TO_DEGREES, system_state_packet.height);
                            pc.printf("\tRoll = %f, Pitch = %f, Heading = %f\n", system_state_packet.orientation[0] * RADIANS_TO_DEGREES, system_state_packet.orientation[1] * RADIANS_TO_DEGREES, system_state_packet.orientation[2] * RADIANS_TO_DEGREES);
                            pc.printf("\tVelocity_north = %f, Velocith_east = %f, Velocity_down = %f\n", system_state_packet.velocity[0], system_state_packet.velocity[1], system_state_packet.velocity[2]);
                        }
                    }
                    else
                    {
                        pc.printf("Packet ID %u of Length %u\n", an_packet->id, an_packet->length);
                    }
                }
               
            }
        }
        
    
}

