/*
 * MISNet   
 *
 *  Display:   Ecran de la version MISNet V0 
 *
 *  Created on: August 17, 2018         Author: Francis CHATAIN
 *
 */

#ifndef __TFTLCD_H__
#define __TFTLCD_H__

// =======================================  Includes 

#include "mbed.h"
#include "DmTftHX8353C.h"
#include "DmTftS6D0164.h"
#include "DmTftIli9325.h"
#include "DmTftIli9341.h"
#include "DmTftSsd2119.h"
#include "DmTftRa8875.h"

#include "main.h"

// =======================================  Define 
#define log(...) printf(__VA_ARGS__) 


// =======================================  Class
class Tftlcd 
{
    // Public variable /method 
    public:  
        void        Init        (void)          ; 
        void        Update      (uint32_t freq, uint16_t bw, uint8_t sf, int8_t pwr, uint8_t bsz, uint16_t timeM) ; 
   
        
    // Private variable /method 
    private:
        int         bmpWidth, bmpHeight     ;
        uint8_t     bmpImageoffset          ;
        char        bufferDisplay[50]       ;
        void        DrawBmpFromFlash   (int x, int y)  ;
        int         BmpReadHeader      ()              ;

        uint16_t    read16 (uint8_t *src) { uint16_t d;uint8_t  b ;b = *src;d = *(src+1);d <<= 8 ;d |= b;return d;}
        uint32_t    read32 (uint8_t *src) { uint32_t d;uint16_t b ;b = read16(src);d = read16(src+2);d <<= 16;d |= b;return d;}
      
    
    // Protected variable /method 
    protected:
    
} ; 

#endif // __DISPLAY_H__
