#include <iostream>
#include <cstdlib>

#include "Context.h"

#include "Value.hpp"
#include "ExtMemory.hpp"
#include "DataBase.hpp"


using namespace misnet;


static void testValues() {
  Value value1, value2;
  value1.setBoolValue(true);
  value2.setBoolValue(false);

  if (value1.compareTo(value2) != 1) {
    DEBUG("ERREUR sur comparaison de valeurs booleennes !");
  }
}


int main(int argc, char** argv) {
  testValues();
  
  Value value;
  value.setDoubleValue(-1.0 / 81);


  DataBase * database = new DataBase();

  ExtMemory::read(database);

  DEBUG("PAYLOAD\n=======\n%s\n", database->getPayload()->toString().c_str());

  for (int i = 0; i < 10000000; ++i) {
    std::list<CandidateComponent*> * candidateComponents = database->getCandidateSensorsList();

    if (candidateComponents->size() != 0) {
      DEBUG("Iteration #%d\n****************\n", i);

      for (std::list<CandidateComponent*>::iterator candidateComponentIterator = candidateComponents->begin();
       candidateComponentIterator != candidateComponents->end();
       candidateComponentIterator++) {
    DEBUG("Candidate component : %d\n", (*candidateComponentIterator)->getComponent()->getId());
    for (std::list<Service*>::iterator serviceIterator = (*candidateComponentIterator)->getServices().begin();
         serviceIterator != (*candidateComponentIterator)->getServices().end();
         serviceIterator++) {
      DEBUG("\tCandidate service : %d\n", (*serviceIterator)->getMisnetCode());
      (*serviceIterator)->setValue(value);
      DEBUG("\tCurrent value : %s\n", (*serviceIterator)->getCurrentValueAsString().c_str());
      DEBUG("\tPrevious value : %s\n", (*serviceIterator)->getPreviousValueAsString().c_str());
    }
      }
    }

    free(candidateComponents);
  }

  return 0;
}
