#include "Service.hpp"

using namespace misnet;

Service::Service( DEVICE_TYPE type,
                 MISNET_CODE misnet_code,
                 STATE state,
                 ACCESS_TYPE access_type,
                 REQUEST_MODE request_mode,
                 UP_MODE up_mode,
                 ACCESS_PIN access_pins[6],
         uint32_t subsample_rate,
         Value& delta_threshold,
         Value& low_threshold_limit,
         Value& high_threshold_limit,
                 ACTION action,
                 OUTPUT_MODE output_mode,
                 std::string comment)
        : device_type(type), misnet_code(misnet_code), state(state),
          access_type(access_type), request_mode(request_mode),
          up_mode(up_mode), subsample_rate(subsample_rate), delta_threshold(delta_threshold),
          low_threshold_limit(low_threshold_limit), high_threshold_limit(high_threshold_limit),
          action(action), output_mode(output_mode),
          comment(comment), activation_nb(0) {
    for (int i = 0; i < 6; i++) {
        this->access_pins[i] = access_pins[i];
    }

    this->current_value._value.type = Value::NOT_SET;
    this->previous_value._value.type = Value::NOT_SET;
}


bool Service::processHeartbeat() {
    if (this->readyToSample()) {
        //DEBUG("\tReady to sample !\n");
        this->activation_nb = 0;
        return true;
    }

    //DEBUG("\tNot ready to sample...\n");
    ++(this->activation_nb);

    return false;
}


bool Service::valueToBeSentToGateway() {
  if (this->up_mode == Service::BY_RANGE) {
    DEBUG("About to compare value %s to low limit (%s) and high limit (%s)\n",
      this->current_value.toString().c_str(), this->low_threshold_limit.toString().c_str(),
      this->high_threshold_limit.toString().c_str());
    return ((this->low_threshold_limit.compareTo(this->current_value) > 0)
        || (this->current_value.compareTo(this->high_threshold_limit) > 0));
  }

  if (this->up_mode == Service::BY_DELTA) {
    return this->current_value.isAbsoluteDifferenceValueGreaterThanDelta(this->previous_value, this->delta_threshold);
  }

  return (this->current_value.isDifferentFrom(this->previous_value));
}
