#include "Payload.hpp"


using namespace misnet;


Payload::Payload(Payload::PAYLOAD_ID id, std::vector<Component*> components, uint16_t base_period)
: _id(id), _components(components), _basePeriod(base_period)  {
    for (std::vector<Component*>::iterator it = this->_components.begin(); it != this->_components.end(); it++) {
        Component* component = *it;
        for(std::vector<Service*>::iterator it = component->getServices().begin(); it != component->getServices().end(); it++) {
            this->_services.push_back(*it);
        }
    }
}


Service* Payload::getServiceByRank(short servicesRank) {
    if (servicesRank < 1 || servicesRank > 6) {
        return (Service*) NULL;
    }

    return this->_services[servicesRank - 1];
}


std::string Payload::toString() {
    std::ostringstream stringStream;

    stringStream << "Payload id : " << this->_id << std::endl;
    stringStream << "It contains " << this->_components.size() << " components" << std::endl;
    stringStream << "List of components :\n------------------" << std::endl;

    std::vector<Component*>::iterator it;
    for (it = this->_components.begin(); it != this->_components.end(); it++) {
        stringStream << (*it)->toString() << std::endl;
    }

    std::vector<Service*> services = this->_services;

    stringStream << "There are " << services.size() << " services." << std::endl;
    stringStream << "List of services :\n------------------" << std::endl;

    for(std::vector<Service*>::iterator it = services.begin(); it != services.end(); it++) {
        Service* service = *it;
        stringStream << service->toString() << std::endl;
    }

    return stringStream.str();
}
