/*
 * MISNet   
 *
 *  Frame:   Gestionnaire de fabrication des messages et décodage des messages recus 
 *
 *  Created on: August 17, 2018         Author: Francis CHATAIN
 *
 */
#ifndef __MESSAGEFACTORY_HPP__
#define __MESSAGEFACTORY_HPP__


#include "Context.h"

#ifndef TEST_ENVIRONMENT
#include "mbed.h"
#endif

#define MODE_ADDR_ST_               0x0000 
#define MODE_ADDR_GEN               0x4000 
#define MODE_ADDR_IOT               0x8000 
#define MODE_ADDR_BCA               0xC000 

#define MODE_DFT_CNF                0x0000 
#define MODE_DFT_IOT                0x4000 
#define MODE_DFT_SYN                0x8000 
#define MODE_DFT_BCA                0xC000 

#define BUFFER_SIZE_MAX             100


namespace misnet {
    class MessageFactory;
}


// =======================================  Class content      
class misnet::MessageFactory {
    
    public:
        MessageFactory();
        virtual ~MessageFactory();  // Attention ! En C++, toujours marquer le destructeur d'une classe
                                    // comme "virtual" si on veut eviter les ennuis en cas d'heritage
                                    // multiple impliquant cette classe.

        // ...et marquer ces fonctions qui sont intrinsèquement statiques comme telles
        // ---------------------------------------------------------------------------
        static void buildSensors        () ; 
        static void buildGoodhealth     () ; 
        static void buildSynchro        () ; 
        static void buildConfiguration  () ; 

    private:

    protected:

} ;

#endif  // __MESSAGEFACTORY_HPP__
